# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .jobs_status import JobsStatus


class Jobs(UncheckedBaseModel):
    """
    Jobs are tasks that are processed asynchronously by the Intercom system after being enqueued via the API. This allows for efficient handling of operations that may take time to complete, such as data imports or exports. You can check the status of your jobs to monitor their progress and ensure they are completed successfully.
    """

    type: typing.Optional[typing.Literal["job"]] = pydantic.Field(default=None)
    """
    The type of the object
    """

    id: str = pydantic.Field()
    """
    The id of the job that's currently being processed or has completed.
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    API endpoint URL to check the job status.
    """

    status: typing.Optional[JobsStatus] = pydantic.Field(default=None)
    """
    The status of the job execution.
    """

    resource_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of resource created during job execution.
    """

    resource_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the resource created during job execution (e.g. ticket id)
    """

    resource_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The url of the resource created during job exeuction. Use this url to fetch the resource.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
