# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawNewsClient, RawNewsClient

if typing.TYPE_CHECKING:
    from .feeds.client import AsyncFeedsClient, FeedsClient
    from .items.client import AsyncItemsClient, ItemsClient


class NewsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawNewsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._items: typing.Optional[ItemsClient] = None
        self._feeds: typing.Optional[FeedsClient] = None

    @property
    def with_raw_response(self) -> RawNewsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawNewsClient
        """
        return self._raw_client

    @property
    def items(self):
        if self._items is None:
            from .items.client import ItemsClient  # noqa: E402

            self._items = ItemsClient(client_wrapper=self._client_wrapper)
        return self._items

    @property
    def feeds(self):
        if self._feeds is None:
            from .feeds.client import FeedsClient  # noqa: E402

            self._feeds = FeedsClient(client_wrapper=self._client_wrapper)
        return self._feeds


class AsyncNewsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawNewsClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._items: typing.Optional[AsyncItemsClient] = None
        self._feeds: typing.Optional[AsyncFeedsClient] = None

    @property
    def with_raw_response(self) -> AsyncRawNewsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawNewsClient
        """
        return self._raw_client

    @property
    def items(self):
        if self._items is None:
            from .items.client import AsyncItemsClient  # noqa: E402

            self._items = AsyncItemsClient(client_wrapper=self._client_wrapper)
        return self._items

    @property
    def feeds(self):
        if self._feeds is None:
            from .feeds.client import AsyncFeedsClient  # noqa: E402

            self._feeds = AsyncFeedsClient(client_wrapper=self._client_wrapper)
        return self._feeds
