# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.note_list import NoteList
from .raw_client import AsyncRawNotesClient, RawNotesClient
from .types.note import Note

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class NotesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawNotesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawNotesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawNotesClient
        """
        return self._raw_client

    def list(
        self,
        contact_id: str,
        *,
        page: typing.Optional[int] = None,
        per_page: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Note, NoteList]:
        """
        You can fetch a list of notes that are associated to a contact.

        Parameters
        ----------
        contact_id : str
            The unique identifier of a contact.

        page : typing.Optional[int]
            The page of results to fetch. Defaults to first page

        per_page : typing.Optional[int]
            How many results to display per page. Defaults to 15

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Note, NoteList]
            Successful response

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        response = client.notes.list(
            contact_id="contact_id",
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(contact_id, page=page, per_page=per_page, request_options=request_options)

    def create(
        self,
        contact_id: str,
        *,
        body: str,
        admin_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Note:
        """
        You can add a note to a single contact.

        Parameters
        ----------
        contact_id : str
            The unique identifier of a given contact.

        body : str
            The text of the note.

        admin_id : typing.Optional[str]
            The unique identifier of a given admin.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Note
            Successful response

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.notes.create(
            contact_id="123",
            body="Hello",
            admin_id="123",
        )
        """
        _response = self._raw_client.create(contact_id, body=body, admin_id=admin_id, request_options=request_options)
        return _response.data

    def find(self, note_id: int, *, request_options: typing.Optional[RequestOptions] = None) -> Note:
        """
        You can fetch the details of a single note.

        Parameters
        ----------
        note_id : int
            The unique identifier of a given note

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Note
            Note found

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.notes.find(
            note_id=1,
        )
        """
        _response = self._raw_client.find(note_id, request_options=request_options)
        return _response.data


class AsyncNotesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawNotesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawNotesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawNotesClient
        """
        return self._raw_client

    async def list(
        self,
        contact_id: str,
        *,
        page: typing.Optional[int] = None,
        per_page: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Note, NoteList]:
        """
        You can fetch a list of notes that are associated to a contact.

        Parameters
        ----------
        contact_id : str
            The unique identifier of a contact.

        page : typing.Optional[int]
            The page of results to fetch. Defaults to first page

        per_page : typing.Optional[int]
            How many results to display per page. Defaults to 15

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Note, NoteList]
            Successful response

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.notes.list(
                contact_id="contact_id",
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(contact_id, page=page, per_page=per_page, request_options=request_options)

    async def create(
        self,
        contact_id: str,
        *,
        body: str,
        admin_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Note:
        """
        You can add a note to a single contact.

        Parameters
        ----------
        contact_id : str
            The unique identifier of a given contact.

        body : str
            The text of the note.

        admin_id : typing.Optional[str]
            The unique identifier of a given admin.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Note
            Successful response

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.notes.create(
                contact_id="123",
                body="Hello",
                admin_id="123",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            contact_id, body=body, admin_id=admin_id, request_options=request_options
        )
        return _response.data

    async def find(self, note_id: int, *, request_options: typing.Optional[RequestOptions] = None) -> Note:
        """
        You can fetch the details of a single note.

        Parameters
        ----------
        note_id : int
            The unique identifier of a given note

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Note
            Note found

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.notes.find(
                note_id=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.find(note_id, request_options=request_options)
        return _response.data
