# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.ticket_type_attribute import TicketTypeAttribute
from .raw_client import AsyncRawAttributesClient, RawAttributesClient
from .types.create_ticket_type_attribute_request_data_type import CreateTicketTypeAttributeRequestDataType

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AttributesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAttributesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAttributesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAttributesClient
        """
        return self._raw_client

    def create(
        self,
        ticket_type_id: str,
        *,
        name: str,
        description: str,
        data_type: CreateTicketTypeAttributeRequestDataType,
        required_to_create: typing.Optional[bool] = OMIT,
        required_to_create_for_contacts: typing.Optional[bool] = OMIT,
        visible_on_create: typing.Optional[bool] = OMIT,
        visible_to_contacts: typing.Optional[bool] = OMIT,
        multiline: typing.Optional[bool] = OMIT,
        list_items: typing.Optional[str] = OMIT,
        allow_multiple_values: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[TicketTypeAttribute]:
        """
        You can create a new attribute for a ticket type.

        Parameters
        ----------
        ticket_type_id : str
            The unique identifier for the ticket type which is given by Intercom.

        name : str
            The name of the ticket type attribute

        description : str
            The description of the attribute presented to the teammate or contact

        data_type : CreateTicketTypeAttributeRequestDataType
            The data type of the attribute

        required_to_create : typing.Optional[bool]
            Whether the attribute is required to be filled in when teammates are creating the ticket in Inbox.

        required_to_create_for_contacts : typing.Optional[bool]
            Whether the attribute is required to be filled in when contacts are creating the ticket in Messenger.

        visible_on_create : typing.Optional[bool]
            Whether the attribute is visible to teammates when creating a ticket in Inbox.

        visible_to_contacts : typing.Optional[bool]
            Whether the attribute is visible to contacts when creating a ticket in Messenger.

        multiline : typing.Optional[bool]
            Whether the attribute allows multiple lines of text (only applicable to string attributes)

        list_items : typing.Optional[str]
            A comma delimited list of items for the attribute value (only applicable to list attributes)

        allow_multiple_values : typing.Optional[bool]
            Whether the attribute allows multiple files to be attached to it (only applicable to file attributes)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[TicketTypeAttribute]
            Ticket Type Attribute created

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.ticket_types.attributes.create(
            ticket_type_id="ticket_type_id",
            name="Attribute Title",
            description="Attribute Description",
            data_type="string",
            required_to_create=False,
        )
        """
        _response = self._raw_client.create(
            ticket_type_id,
            name=name,
            description=description,
            data_type=data_type,
            required_to_create=required_to_create,
            required_to_create_for_contacts=required_to_create_for_contacts,
            visible_on_create=visible_on_create,
            visible_to_contacts=visible_to_contacts,
            multiline=multiline,
            list_items=list_items,
            allow_multiple_values=allow_multiple_values,
            request_options=request_options,
        )
        return _response.data

    def update(
        self,
        ticket_type_id: str,
        attribute_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        required_to_create: typing.Optional[bool] = OMIT,
        required_to_create_for_contacts: typing.Optional[bool] = OMIT,
        visible_on_create: typing.Optional[bool] = OMIT,
        visible_to_contacts: typing.Optional[bool] = OMIT,
        multiline: typing.Optional[bool] = OMIT,
        list_items: typing.Optional[str] = OMIT,
        allow_multiple_values: typing.Optional[bool] = OMIT,
        archived: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[TicketTypeAttribute]:
        """
        You can update an existing attribute for a ticket type.

        Parameters
        ----------
        ticket_type_id : str
            The unique identifier for the ticket type which is given by Intercom.

        attribute_id : str
            The unique identifier for the ticket type attribute which is given by Intercom.

        name : typing.Optional[str]
            The name of the ticket type attribute

        description : typing.Optional[str]
            The description of the attribute presented to the teammate or contact

        required_to_create : typing.Optional[bool]
            Whether the attribute is required to be filled in when teammates are creating the ticket in Inbox.

        required_to_create_for_contacts : typing.Optional[bool]
            Whether the attribute is required to be filled in when contacts are creating the ticket in Messenger.

        visible_on_create : typing.Optional[bool]
            Whether the attribute is visible to teammates when creating a ticket in Inbox.

        visible_to_contacts : typing.Optional[bool]
            Whether the attribute is visible to contacts when creating a ticket in Messenger.

        multiline : typing.Optional[bool]
            Whether the attribute allows multiple lines of text (only applicable to string attributes)

        list_items : typing.Optional[str]
            A comma delimited list of items for the attribute value (only applicable to list attributes)

        allow_multiple_values : typing.Optional[bool]
            Whether the attribute allows multiple files to be attached to it (only applicable to file attributes)

        archived : typing.Optional[bool]
            Whether the attribute should be archived and not shown during creation of the ticket (it will still be present on previously created tickets)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[TicketTypeAttribute]
            Ticket Type Attribute updated

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.ticket_types.attributes.update(
            ticket_type_id="ticket_type_id",
            attribute_id="attribute_id",
            description="New Attribute Description",
        )
        """
        _response = self._raw_client.update(
            ticket_type_id,
            attribute_id,
            name=name,
            description=description,
            required_to_create=required_to_create,
            required_to_create_for_contacts=required_to_create_for_contacts,
            visible_on_create=visible_on_create,
            visible_to_contacts=visible_to_contacts,
            multiline=multiline,
            list_items=list_items,
            allow_multiple_values=allow_multiple_values,
            archived=archived,
            request_options=request_options,
        )
        return _response.data


class AsyncAttributesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAttributesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAttributesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAttributesClient
        """
        return self._raw_client

    async def create(
        self,
        ticket_type_id: str,
        *,
        name: str,
        description: str,
        data_type: CreateTicketTypeAttributeRequestDataType,
        required_to_create: typing.Optional[bool] = OMIT,
        required_to_create_for_contacts: typing.Optional[bool] = OMIT,
        visible_on_create: typing.Optional[bool] = OMIT,
        visible_to_contacts: typing.Optional[bool] = OMIT,
        multiline: typing.Optional[bool] = OMIT,
        list_items: typing.Optional[str] = OMIT,
        allow_multiple_values: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[TicketTypeAttribute]:
        """
        You can create a new attribute for a ticket type.

        Parameters
        ----------
        ticket_type_id : str
            The unique identifier for the ticket type which is given by Intercom.

        name : str
            The name of the ticket type attribute

        description : str
            The description of the attribute presented to the teammate or contact

        data_type : CreateTicketTypeAttributeRequestDataType
            The data type of the attribute

        required_to_create : typing.Optional[bool]
            Whether the attribute is required to be filled in when teammates are creating the ticket in Inbox.

        required_to_create_for_contacts : typing.Optional[bool]
            Whether the attribute is required to be filled in when contacts are creating the ticket in Messenger.

        visible_on_create : typing.Optional[bool]
            Whether the attribute is visible to teammates when creating a ticket in Inbox.

        visible_to_contacts : typing.Optional[bool]
            Whether the attribute is visible to contacts when creating a ticket in Messenger.

        multiline : typing.Optional[bool]
            Whether the attribute allows multiple lines of text (only applicable to string attributes)

        list_items : typing.Optional[str]
            A comma delimited list of items for the attribute value (only applicable to list attributes)

        allow_multiple_values : typing.Optional[bool]
            Whether the attribute allows multiple files to be attached to it (only applicable to file attributes)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[TicketTypeAttribute]
            Ticket Type Attribute created

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.ticket_types.attributes.create(
                ticket_type_id="ticket_type_id",
                name="Attribute Title",
                description="Attribute Description",
                data_type="string",
                required_to_create=False,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            ticket_type_id,
            name=name,
            description=description,
            data_type=data_type,
            required_to_create=required_to_create,
            required_to_create_for_contacts=required_to_create_for_contacts,
            visible_on_create=visible_on_create,
            visible_to_contacts=visible_to_contacts,
            multiline=multiline,
            list_items=list_items,
            allow_multiple_values=allow_multiple_values,
            request_options=request_options,
        )
        return _response.data

    async def update(
        self,
        ticket_type_id: str,
        attribute_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        required_to_create: typing.Optional[bool] = OMIT,
        required_to_create_for_contacts: typing.Optional[bool] = OMIT,
        visible_on_create: typing.Optional[bool] = OMIT,
        visible_to_contacts: typing.Optional[bool] = OMIT,
        multiline: typing.Optional[bool] = OMIT,
        list_items: typing.Optional[str] = OMIT,
        allow_multiple_values: typing.Optional[bool] = OMIT,
        archived: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[TicketTypeAttribute]:
        """
        You can update an existing attribute for a ticket type.

        Parameters
        ----------
        ticket_type_id : str
            The unique identifier for the ticket type which is given by Intercom.

        attribute_id : str
            The unique identifier for the ticket type attribute which is given by Intercom.

        name : typing.Optional[str]
            The name of the ticket type attribute

        description : typing.Optional[str]
            The description of the attribute presented to the teammate or contact

        required_to_create : typing.Optional[bool]
            Whether the attribute is required to be filled in when teammates are creating the ticket in Inbox.

        required_to_create_for_contacts : typing.Optional[bool]
            Whether the attribute is required to be filled in when contacts are creating the ticket in Messenger.

        visible_on_create : typing.Optional[bool]
            Whether the attribute is visible to teammates when creating a ticket in Inbox.

        visible_to_contacts : typing.Optional[bool]
            Whether the attribute is visible to contacts when creating a ticket in Messenger.

        multiline : typing.Optional[bool]
            Whether the attribute allows multiple lines of text (only applicable to string attributes)

        list_items : typing.Optional[str]
            A comma delimited list of items for the attribute value (only applicable to list attributes)

        allow_multiple_values : typing.Optional[bool]
            Whether the attribute allows multiple files to be attached to it (only applicable to file attributes)

        archived : typing.Optional[bool]
            Whether the attribute should be archived and not shown during creation of the ticket (it will still be present on previously created tickets)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[TicketTypeAttribute]
            Ticket Type Attribute updated

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.ticket_types.attributes.update(
                ticket_type_id="ticket_type_id",
                attribute_id="attribute_id",
                description="New Attribute Description",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            ticket_type_id,
            attribute_id,
            name=name,
            description=description,
            required_to_create=required_to_create,
            required_to_create_for_contacts=required_to_create_for_contacts,
            visible_on_create=visible_on_create,
            visible_to_contacts=visible_to_contacts,
            multiline=multiline,
            list_items=list_items,
            allow_multiple_values=allow_multiple_values,
            archived=archived,
            request_options=request_options,
        )
        return _response.data
