# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from ...types.linked_object_list import LinkedObjectList
from ...types.ticket_custom_attributes import TicketCustomAttributes
from ...types.ticket_parts import TicketParts
from .ticket_category import TicketCategory
from .ticket_contacts import TicketContacts
from .ticket_state import TicketState
from .ticket_type import TicketType


class Ticket(UncheckedBaseModel):
    """
    Tickets are how you track requests from your users.
    """

    type: typing.Optional[typing.Literal["ticket"]] = pydantic.Field(default=None)
    """
    Always ticket
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier for the ticket which is given by Intercom.
    """

    ticket_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The ID of the Ticket used in the Intercom Inbox and Messenger. Do not use ticket_id for API queries.
    """

    category: typing.Optional[TicketCategory] = pydantic.Field(default=None)
    """
    Category of the Ticket.
    """

    ticket_attributes: typing.Optional[TicketCustomAttributes] = None
    ticket_state: typing.Optional[TicketState] = None
    ticket_type: typing.Optional[TicketType] = None
    contacts: typing.Optional[TicketContacts] = None
    admin_assignee_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id representing the admin assigned to the ticket.
    """

    team_assignee_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id representing the team assigned to the ticket.
    """

    created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time the ticket was created as a UTC Unix timestamp.
    """

    updated_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The last time the ticket was updated as a UTC Unix timestamp.
    """

    open: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether or not the ticket is open. If false, the ticket is closed.
    """

    snoozed_until: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time the ticket will be snoozed until as a UTC Unix timestamp. If null, the ticket is not currently snoozed.
    """

    linked_objects: typing.Optional[LinkedObjectList] = None
    ticket_parts: typing.Optional[TicketParts] = None
    is_shared: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether or not the ticket is shared with the customer.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
