# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from ...types.part_attachment import PartAttachment
from ...types.reference import Reference
from ...types.ticket_part_author import TicketPartAuthor
from .ticket_part_previous_ticket_state import TicketPartPreviousTicketState
from .ticket_part_ticket_state import TicketPartTicketState
from .ticket_part_updated_attribute_data import TicketPartUpdatedAttributeData


class TicketPart(UncheckedBaseModel):
    """
    A Ticket Part represents a message in the ticket.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    Always ticket_part
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id representing the ticket part.
    """

    part_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of ticket part.
    """

    body: typing.Optional[str] = pydantic.Field(default=None)
    """
    The message body, which may contain HTML.
    """

    previous_ticket_state: typing.Optional[TicketPartPreviousTicketState] = pydantic.Field(default=None)
    """
    The previous state of the ticket.
    """

    ticket_state: typing.Optional[TicketPartTicketState] = pydantic.Field(default=None)
    """
    The state of the ticket.
    """

    created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time the ticket part was created.
    """

    updated_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The last time the ticket part was updated.
    """

    assigned_to: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The id of the admin that was assigned the ticket by this ticket_part (null if there has been no change in assignment.)
    """

    author: typing.Optional[TicketPartAuthor] = None
    attachments: typing.Optional[typing.List[PartAttachment]] = pydantic.Field(default=None)
    """
    A list of attachments for the part.
    """

    external_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The external id of the ticket part
    """

    redacted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether or not the ticket part has been redacted.
    """

    app_package_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    The app package code if this part was created via API. Note this field won't show if the part was not created via API.
    """

    updated_attribute_data: typing.Optional[TicketPartUpdatedAttributeData] = pydantic.Field(default=None)
    """
    The updated attribute data of the ticket part. Only present for attribute update parts.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
