# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .ticket_state_detailed_category import TicketStateDetailedCategory
from .ticket_state_detailed_ticket_types import TicketStateDetailedTicketTypes


class TicketStateDetailed(UncheckedBaseModel):
    """
    A ticket state, used to define the state of a ticket.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    String representing the object's type. Always has the value `ticket_state`.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the ticket state
    """

    category: typing.Optional[TicketStateDetailedCategory] = pydantic.Field(default=None)
    """
    The category of the ticket state
    """

    internal_label: typing.Optional[str] = pydantic.Field(default=None)
    """
    The state the ticket is currently in, in a human readable form - visible in Intercom
    """

    external_label: typing.Optional[str] = pydantic.Field(default=None)
    """
    The state the ticket is currently in, in a human readable form - visible to customers, in the messenger, email and tickets portal.
    """

    archived: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the ticket state is archived
    """

    ticket_types: typing.Optional[TicketStateDetailedTicketTypes] = pydantic.Field(default=None)
    """
    A list of ticket types associated with a given ticket state.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
