# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from ...types.ticket_type_attribute_list import TicketTypeAttributeList
from .ticket_type_category import TicketTypeCategory
from .ticket_type_ticket_states import TicketTypeTicketStates


class TicketType(UncheckedBaseModel):
    """
    A ticket type, used to define the data fields to be captured in a ticket.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    String representing the object's type. Always has the value `ticket_type`.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id representing the ticket type.
    """

    category: typing.Optional[TicketTypeCategory] = pydantic.Field(default=None)
    """
    Category of the Ticket Type.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the ticket type
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the ticket type
    """

    icon: typing.Optional[str] = pydantic.Field(default=None)
    """
    The icon of the ticket type
    """

    workspace_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the workspace that the ticket type belongs to.
    """

    ticket_type_attributes: typing.Optional[TicketTypeAttributeList] = None
    ticket_states: typing.Optional[TicketTypeTicketStates] = pydantic.Field(default=None)
    """
    A list of ticket states associated with a given ticket type.
    """

    archived: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the ticket type is archived or not.
    """

    created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The date and time the ticket type was created.
    """

    updated_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The date and time the ticket type was last updated.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
