# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .contact_reply_base_request_reply_options_item import ContactReplyBaseRequestReplyOptionsItem


class ContactReplyBaseRequest(UncheckedBaseModel):
    message_type: typing.Literal["comment"] = "comment"
    type: typing.Literal["user"] = "user"
    body: str = pydantic.Field()
    """
    The text body of the comment.
    """

    created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time the reply was created. If not provided, the current time will be used.
    """

    attachment_urls: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    A list of image URLs that will be added as attachments. You can include up to 10 URLs.
    """

    reply_options: typing.Optional[typing.List[ContactReplyBaseRequestReplyOptionsItem]] = pydantic.Field(default=None)
    """
    The quick reply selection the contact wishes to respond with. These map to buttons displayed in the Messenger UI if sent by a bot, or the reply options sent by an Admin via the API.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
