# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class ConversationPartAuthor(UncheckedBaseModel):
    """
    The object who initiated the conversation, which can be a Contact, Admin or Team. Bots and campaigns send messages on behalf of Admins or Teams. For Twitter, this will be blank.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of the author
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the author
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the author
    """

    email: typing.Optional[str] = pydantic.Field(default=None)
    """
    The email of the author
    """

    from_ai_agent: typing.Optional[bool] = pydantic.Field(default=None)
    """
    If this conversation part was sent by the AI Agent
    """

    is_ai_answer: typing.Optional[bool] = pydantic.Field(default=None)
    """
    If this conversation part body was generated by the AI Agent
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
