# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .contact_reference import ContactReference
from .reference import Reference


class ConversationRating(UncheckedBaseModel):
    """
    The Conversation Rating object which contains information on the rating and/or remark added by a Contact and the Admin assigned to the conversation.
    """

    rating: typing.Optional[int] = pydantic.Field(default=None)
    """
    The rating, between 1 and 5, for the conversation.
    """

    remark: typing.Optional[str] = pydantic.Field(default=None)
    """
    An optional field to add a remark to correspond to the number rating
    """

    created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time the rating was requested in the conversation being rated.
    """

    updated_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time the rating was last updated.
    """

    contact: typing.Optional[ContactReference] = None
    teammate: typing.Optional[Reference] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
