# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class FileAttribute(UncheckedBaseModel):
    """
    The value describing a file upload set for a custom attribute
    """

    type: typing.Optional[str] = None
    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the file
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The url of the file. This is a temporary URL and will expire after 30 minutes.
    """

    content_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of file
    """

    filesize: typing.Optional[int] = pydantic.Field(default=None)
    """
    The size of the file in bytes
    """

    width: typing.Optional[int] = pydantic.Field(default=None)
    """
    The width of the file in pixels, if applicable
    """

    height: typing.Optional[int] = pydantic.Field(default=None)
    """
    The height of the file in pixels, if applicable
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
