# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from .raw_client import AsyncRawBrandsClient, RawBrandsClient
from .types.brand import Brand
from .types.brand_list import BrandList


class BrandsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawBrandsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawBrandsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawBrandsClient
        """
        return self._raw_client

    def list_brands(self, *, request_options: typing.Optional[RequestOptions] = None) -> BrandList:
        """
        Retrieves all brands for the workspace, including the default brand.
        The default brand id always matches the workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BrandList
            Successful response

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.brands.list_brands()
        """
        _response = self._raw_client.list_brands(request_options=request_options)
        return _response.data

    def retrieve_brand(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Brand:
        """
        Fetches a specific brand by its unique identifier

        Parameters
        ----------
        id : str
            The unique identifier of the brand

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Brand
            Successful response

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.brands.retrieve_brand(
            id="id",
        )
        """
        _response = self._raw_client.retrieve_brand(id, request_options=request_options)
        return _response.data


class AsyncBrandsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawBrandsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawBrandsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawBrandsClient
        """
        return self._raw_client

    async def list_brands(self, *, request_options: typing.Optional[RequestOptions] = None) -> BrandList:
        """
        Retrieves all brands for the workspace, including the default brand.
        The default brand id always matches the workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BrandList
            Successful response

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.brands.list_brands()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_brands(request_options=request_options)
        return _response.data

    async def retrieve_brand(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Brand:
        """
        Fetches a specific brand by its unique identifier

        Parameters
        ----------
        id : str
            The unique identifier of the brand

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Brand
            Successful response

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.brands.retrieve_brand(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve_brand(id, request_options=request_options)
        return _response.data
