# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel


class Brand(UncheckedBaseModel):
    """
    Represents a branding configuration for the workspace
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of object
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique brand identifier. For default brand, matches the workspace ID
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Display name of the brand
    """

    is_default: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this is the workspace's default brand
    """

    created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    Unix timestamp of brand creation
    """

    updated_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    Unix timestamp of last modification
    """

    help_center_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Associated help center identifier
    """

    default_address_settings_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Default email settings ID for this brand
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
