# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from ...types.datetime import Datetime


class Call(UncheckedBaseModel):
    """
    Represents a phone call in Intercom
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    String representing the object's type. Always has the value `call`.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the call.
    """

    conversation_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the conversation associated with the call, if any.
    """

    admin_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the admin associated with the call, if any.
    """

    contact_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the contact associated with the call, if any.
    """

    state: typing.Optional[str] = pydantic.Field(default=None)
    """
    The current state of the call.
    """

    initiated_at: typing.Optional[Datetime] = None
    answered_at: typing.Optional[Datetime] = None
    ended_at: typing.Optional[Datetime] = None
    created_at: typing.Optional[Datetime] = None
    updated_at: typing.Optional[Datetime] = None
    recording_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    API URL to download or redirect to the call recording if available.
    """

    transcription_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    API URL to the call transcript if available.
    """

    call_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of call.
    """

    direction: typing.Optional[str] = pydantic.Field(default=None)
    """
    The direction of the call.
    """

    ended_reason: typing.Optional[str] = pydantic.Field(default=None)
    """
    The reason for the call end, if applicable.
    """

    phone: typing.Optional[str] = pydantic.Field(default=None)
    """
    The phone number involved in the call, in E.164 format.
    """

    fin_recording_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    API URL to the AI Agent (Fin) call recording if available.
    """

    fin_transcription_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    API URL to the AI Agent (Fin) call transcript if available.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
