# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ..types.custom_channel_attribute import CustomChannelAttribute
from ..types.custom_channel_contact import CustomChannelContact
from ..types.custom_channel_notification_response import CustomChannelNotificationResponse
from .raw_client import AsyncRawCustomChannelEventsClient, RawCustomChannelEventsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CustomChannelEventsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCustomChannelEventsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCustomChannelEventsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCustomChannelEventsClient
        """
        return self._raw_client

    def notify_new_conversation(
        self,
        *,
        event_id: str,
        external_conversation_id: str,
        contact: CustomChannelContact,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CustomChannelNotificationResponse:
        """
        Notifies Intercom that a new conversation was created in your custom channel/platform. This triggers conversation creation and workflow automations within Intercom for your custom channel integration.
        > **Note:** This endpoint is currently under managed availability. Please reach out to your accounts team to discuss access and tailored, hands-on support.

        Parameters
        ----------
        event_id : str
            Unique identifier for the event.

        external_conversation_id : str
            Identifier for the conversation in your application.

        contact : CustomChannelContact

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CustomChannelNotificationResponse
            Successfully notified Intercom

        Examples
        --------
        from intercom import Intercom
        from intercom.unstable import CustomChannelContact

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.custom_channel_events.notify_new_conversation(
            event_id="evt_12345",
            external_conversation_id="conv_67890",
            contact=CustomChannelContact(
                type="user",
                external_id="user_001",
                name="Jane Doe",
                email="jane.doe@example.com",
            ),
        )
        """
        _response = self._raw_client.notify_new_conversation(
            event_id=event_id,
            external_conversation_id=external_conversation_id,
            contact=contact,
            request_options=request_options,
        )
        return _response.data

    def notify_new_message(
        self,
        *,
        body: str,
        event_id: str,
        external_conversation_id: str,
        contact: CustomChannelContact,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CustomChannelNotificationResponse:
        """
        Notifies Intercom that a new message was sent in a conversation on your custom channel/platform. This allows Intercom to process the message and trigger any relevant workflow automations.
        > **Note:** This endpoint is currently under managed availability. Please reach out to your accounts team to discuss access and tailored, hands-on support.

        Parameters
        ----------
        body : str
            The message content sent by the user.

        event_id : str
            Unique identifier for the event.

        external_conversation_id : str
            Identifier for the conversation in your application.

        contact : CustomChannelContact

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CustomChannelNotificationResponse
            Successfully notified Intercom

        Examples
        --------
        from intercom import Intercom
        from intercom.unstable import CustomChannelContact

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.custom_channel_events.notify_new_message(
            event_id="evt_54321",
            external_conversation_id="conv_98765",
            contact=CustomChannelContact(
                type="user",
                external_id="user_002",
                name="John Smith",
                email="john.smith@example.com",
            ),
            body="Hello, I need help with my order.",
        )
        """
        _response = self._raw_client.notify_new_message(
            body=body,
            event_id=event_id,
            external_conversation_id=external_conversation_id,
            contact=contact,
            request_options=request_options,
        )
        return _response.data

    def notify_quick_reply_selected(
        self,
        *,
        quick_reply_option_id: str,
        event_id: str,
        external_conversation_id: str,
        contact: CustomChannelContact,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CustomChannelNotificationResponse:
        """
        Notifies Intercom that a user selected a quick reply option in your custom channel/platform. This allows Intercom to process the response and trigger any relevant workflow automations.
        > **Note:** This endpoint is currently under managed availability. Please reach out to your accounts team to discuss access and tailored, hands-on support.

        Parameters
        ----------
        quick_reply_option_id : str
            Id of the selected quick reply option.

        event_id : str
            Unique identifier for the event.

        external_conversation_id : str
            Identifier for the conversation in your application.

        contact : CustomChannelContact

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CustomChannelNotificationResponse
            Successfully notified Intercom

        Examples
        --------
        from intercom import Intercom
        from intercom.unstable import CustomChannelContact

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.custom_channel_events.notify_quick_reply_selected(
            event_id="evt_67890",
            external_conversation_id="conv_13579",
            contact=CustomChannelContact(
                type="user",
                external_id="user_003",
                name="Alice Example",
                email="alice@example.com",
            ),
            quick_reply_option_id="1234",
        )
        """
        _response = self._raw_client.notify_quick_reply_selected(
            quick_reply_option_id=quick_reply_option_id,
            event_id=event_id,
            external_conversation_id=external_conversation_id,
            contact=contact,
            request_options=request_options,
        )
        return _response.data

    def notify_attribute_collected(
        self,
        *,
        attribute: CustomChannelAttribute,
        event_id: str,
        external_conversation_id: str,
        contact: CustomChannelContact,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CustomChannelNotificationResponse:
        """
        Notifies Intercom that a user provided a response to an attribute collector in your custom channel/platform. This allows Intercom to process the attribute and trigger any relevant workflow automations.
        > **Note:** This endpoint is currently under managed availability. Please reach out to your accounts team to discuss access and tailored, hands-on support.

        Parameters
        ----------
        attribute : CustomChannelAttribute

        event_id : str
            Unique identifier for the event.

        external_conversation_id : str
            Identifier for the conversation in your application.

        contact : CustomChannelContact

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CustomChannelNotificationResponse
            Successfully notified Intercom

        Examples
        --------
        from intercom import Intercom
        from intercom.unstable import CustomChannelAttribute, CustomChannelContact

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.custom_channel_events.notify_attribute_collected(
            event_id="evt_24680",
            external_conversation_id="conv_11223",
            contact=CustomChannelContact(
                type="user",
                external_id="user_004",
                name="Bob Example",
                email="bob@example.com",
            ),
            attribute=CustomChannelAttribute(
                id="shipping_address",
                value="123 Main St, Springfield",
            ),
        )
        """
        _response = self._raw_client.notify_attribute_collected(
            attribute=attribute,
            event_id=event_id,
            external_conversation_id=external_conversation_id,
            contact=contact,
            request_options=request_options,
        )
        return _response.data


class AsyncCustomChannelEventsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCustomChannelEventsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCustomChannelEventsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCustomChannelEventsClient
        """
        return self._raw_client

    async def notify_new_conversation(
        self,
        *,
        event_id: str,
        external_conversation_id: str,
        contact: CustomChannelContact,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CustomChannelNotificationResponse:
        """
        Notifies Intercom that a new conversation was created in your custom channel/platform. This triggers conversation creation and workflow automations within Intercom for your custom channel integration.
        > **Note:** This endpoint is currently under managed availability. Please reach out to your accounts team to discuss access and tailored, hands-on support.

        Parameters
        ----------
        event_id : str
            Unique identifier for the event.

        external_conversation_id : str
            Identifier for the conversation in your application.

        contact : CustomChannelContact

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CustomChannelNotificationResponse
            Successfully notified Intercom

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom
        from intercom.unstable import CustomChannelContact

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.custom_channel_events.notify_new_conversation(
                event_id="evt_12345",
                external_conversation_id="conv_67890",
                contact=CustomChannelContact(
                    type="user",
                    external_id="user_001",
                    name="Jane Doe",
                    email="jane.doe@example.com",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.notify_new_conversation(
            event_id=event_id,
            external_conversation_id=external_conversation_id,
            contact=contact,
            request_options=request_options,
        )
        return _response.data

    async def notify_new_message(
        self,
        *,
        body: str,
        event_id: str,
        external_conversation_id: str,
        contact: CustomChannelContact,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CustomChannelNotificationResponse:
        """
        Notifies Intercom that a new message was sent in a conversation on your custom channel/platform. This allows Intercom to process the message and trigger any relevant workflow automations.
        > **Note:** This endpoint is currently under managed availability. Please reach out to your accounts team to discuss access and tailored, hands-on support.

        Parameters
        ----------
        body : str
            The message content sent by the user.

        event_id : str
            Unique identifier for the event.

        external_conversation_id : str
            Identifier for the conversation in your application.

        contact : CustomChannelContact

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CustomChannelNotificationResponse
            Successfully notified Intercom

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom
        from intercom.unstable import CustomChannelContact

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.custom_channel_events.notify_new_message(
                event_id="evt_54321",
                external_conversation_id="conv_98765",
                contact=CustomChannelContact(
                    type="user",
                    external_id="user_002",
                    name="John Smith",
                    email="john.smith@example.com",
                ),
                body="Hello, I need help with my order.",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.notify_new_message(
            body=body,
            event_id=event_id,
            external_conversation_id=external_conversation_id,
            contact=contact,
            request_options=request_options,
        )
        return _response.data

    async def notify_quick_reply_selected(
        self,
        *,
        quick_reply_option_id: str,
        event_id: str,
        external_conversation_id: str,
        contact: CustomChannelContact,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CustomChannelNotificationResponse:
        """
        Notifies Intercom that a user selected a quick reply option in your custom channel/platform. This allows Intercom to process the response and trigger any relevant workflow automations.
        > **Note:** This endpoint is currently under managed availability. Please reach out to your accounts team to discuss access and tailored, hands-on support.

        Parameters
        ----------
        quick_reply_option_id : str
            Id of the selected quick reply option.

        event_id : str
            Unique identifier for the event.

        external_conversation_id : str
            Identifier for the conversation in your application.

        contact : CustomChannelContact

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CustomChannelNotificationResponse
            Successfully notified Intercom

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom
        from intercom.unstable import CustomChannelContact

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.custom_channel_events.notify_quick_reply_selected(
                event_id="evt_67890",
                external_conversation_id="conv_13579",
                contact=CustomChannelContact(
                    type="user",
                    external_id="user_003",
                    name="Alice Example",
                    email="alice@example.com",
                ),
                quick_reply_option_id="1234",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.notify_quick_reply_selected(
            quick_reply_option_id=quick_reply_option_id,
            event_id=event_id,
            external_conversation_id=external_conversation_id,
            contact=contact,
            request_options=request_options,
        )
        return _response.data

    async def notify_attribute_collected(
        self,
        *,
        attribute: CustomChannelAttribute,
        event_id: str,
        external_conversation_id: str,
        contact: CustomChannelContact,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CustomChannelNotificationResponse:
        """
        Notifies Intercom that a user provided a response to an attribute collector in your custom channel/platform. This allows Intercom to process the attribute and trigger any relevant workflow automations.
        > **Note:** This endpoint is currently under managed availability. Please reach out to your accounts team to discuss access and tailored, hands-on support.

        Parameters
        ----------
        attribute : CustomChannelAttribute

        event_id : str
            Unique identifier for the event.

        external_conversation_id : str
            Identifier for the conversation in your application.

        contact : CustomChannelContact

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CustomChannelNotificationResponse
            Successfully notified Intercom

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom
        from intercom.unstable import CustomChannelAttribute, CustomChannelContact

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.custom_channel_events.notify_attribute_collected(
                event_id="evt_24680",
                external_conversation_id="conv_11223",
                contact=CustomChannelContact(
                    type="user",
                    external_id="user_004",
                    name="Bob Example",
                    email="bob@example.com",
                ),
                attribute=CustomChannelAttribute(
                    id="shipping_address",
                    value="123 Main St, Springfield",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.notify_attribute_collected(
            attribute=attribute,
            event_id=event_id,
            external_conversation_id=external_conversation_id,
            contact=contact,
            request_options=request_options,
        )
        return _response.data
