# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from .raw_client import AsyncRawEmailsClient, RawEmailsClient
from .types.email_list import EmailList
from .types.email_setting import EmailSetting


class EmailsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawEmailsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawEmailsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawEmailsClient
        """
        return self._raw_client

    def list_emails(self, *, request_options: typing.Optional[RequestOptions] = None) -> EmailList:
        """
        Lists all sender email address settings for the workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EmailList
            Successful response

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.emails.list_emails()
        """
        _response = self._raw_client.list_emails(request_options=request_options)
        return _response.data

    def retrieve_email(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> EmailSetting:
        """
        Fetches a specific email setting by its unique identifier

        Parameters
        ----------
        id : str
            The unique identifier of the email setting

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EmailSetting
            Successful response

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.emails.retrieve_email(
            id="id",
        )
        """
        _response = self._raw_client.retrieve_email(id, request_options=request_options)
        return _response.data


class AsyncEmailsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawEmailsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawEmailsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawEmailsClient
        """
        return self._raw_client

    async def list_emails(self, *, request_options: typing.Optional[RequestOptions] = None) -> EmailList:
        """
        Lists all sender email address settings for the workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EmailList
            Successful response

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.emails.list_emails()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_emails(request_options=request_options)
        return _response.data

    async def retrieve_email(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> EmailSetting:
        """
        Fetches a specific email setting by its unique identifier

        Parameters
        ----------
        id : str
            The unique identifier of the email setting

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EmailSetting
            Successful response

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.emails.retrieve_email(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve_email(id, request_options=request_options)
        return _response.data
