# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ..articles.types.internal_article import InternalArticle
from ..types.create_internal_article_request import CreateInternalArticleRequest
from ..types.deleted_internal_article_object import DeletedInternalArticleObject
from ..types.internal_article_list import InternalArticleList
from .raw_client import AsyncRawInternalArticlesClient, RawInternalArticlesClient
from .types.internal_article_search_response import InternalArticleSearchResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class InternalArticlesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawInternalArticlesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawInternalArticlesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawInternalArticlesClient
        """
        return self._raw_client

    def list_internal_articles(self, *, request_options: typing.Optional[RequestOptions] = None) -> InternalArticleList:
        """
        You can fetch a list of all internal articles by making a GET request to `https://api.intercom.io/internal_articles`.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InternalArticleList
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.internal_articles.list_internal_articles()
        """
        _response = self._raw_client.list_internal_articles(request_options=request_options)
        return _response.data

    def create_internal_article(
        self,
        *,
        request: typing.Optional[CreateInternalArticleRequest] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> InternalArticle:
        """
        You can create a new internal article by making a POST request to `https://api.intercom.io/internal_articles`.

        Parameters
        ----------
        request : typing.Optional[CreateInternalArticleRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InternalArticle
            internal article created

        Examples
        --------
        from intercom import Intercom
        from intercom.unstable import CreateInternalArticleRequest

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.internal_articles.create_internal_article(
            request=CreateInternalArticleRequest(
                title="Thanks for everything",
                body="Body of the Article",
                author_id=991266252,
                owner_id=991266252,
            ),
        )
        """
        _response = self._raw_client.create_internal_article(request=request, request_options=request_options)
        return _response.data

    def retrieve_internal_article(
        self, id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> InternalArticle:
        """
        You can fetch the details of a single internal article by making a GET request to `https://api.intercom.io/internal_articles/<id>`.

        Parameters
        ----------
        id : int
            The unique identifier for the article which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InternalArticle
            Internal article found

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.internal_articles.retrieve_internal_article(
            id=1,
        )
        """
        _response = self._raw_client.retrieve_internal_article(id, request_options=request_options)
        return _response.data

    def update_internal_article(
        self,
        id: int,
        *,
        title: typing.Optional[str] = OMIT,
        body: typing.Optional[str] = OMIT,
        author_id: typing.Optional[int] = OMIT,
        owner_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> InternalArticle:
        """
        You can update the details of a single internal article by making a PUT request to `https://api.intercom.io/internal_articles/<id>`.

        Parameters
        ----------
        id : int
            The unique identifier for the internal article which is given by Intercom.

        title : typing.Optional[str]
            The title of the article.

        body : typing.Optional[str]
            The content of the article.

        author_id : typing.Optional[int]
            The id of the author of the article.

        owner_id : typing.Optional[int]
            The id of the author of the article.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InternalArticle
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.internal_articles.update_internal_article(
            id=1,
            title="Christmas is here!",
            body="<p>New gifts in store for the jolly season</p>",
        )
        """
        _response = self._raw_client.update_internal_article(
            id, title=title, body=body, author_id=author_id, owner_id=owner_id, request_options=request_options
        )
        return _response.data

    def delete_internal_article(
        self, id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeletedInternalArticleObject:
        """
        You can delete a single internal article by making a DELETE request to `https://api.intercom.io/internal_articles/<id>`.

        Parameters
        ----------
        id : int
            The unique identifier for the internal article which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeletedInternalArticleObject
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.internal_articles.delete_internal_article(
            id=1,
        )
        """
        _response = self._raw_client.delete_internal_article(id, request_options=request_options)
        return _response.data

    def search_internal_articles(
        self, *, folder_id: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> InternalArticleSearchResponse:
        """
        You can search for internal articles by making a GET request to `https://api.intercom.io/internal_articles/search`.

        Parameters
        ----------
        folder_id : typing.Optional[str]
            The ID of the folder to search in.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InternalArticleSearchResponse
            Search successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.internal_articles.search_internal_articles(
            folder_id="folder_id",
        )
        """
        _response = self._raw_client.search_internal_articles(folder_id=folder_id, request_options=request_options)
        return _response.data


class AsyncInternalArticlesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawInternalArticlesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawInternalArticlesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawInternalArticlesClient
        """
        return self._raw_client

    async def list_internal_articles(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> InternalArticleList:
        """
        You can fetch a list of all internal articles by making a GET request to `https://api.intercom.io/internal_articles`.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InternalArticleList
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.internal_articles.list_internal_articles()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_internal_articles(request_options=request_options)
        return _response.data

    async def create_internal_article(
        self,
        *,
        request: typing.Optional[CreateInternalArticleRequest] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> InternalArticle:
        """
        You can create a new internal article by making a POST request to `https://api.intercom.io/internal_articles`.

        Parameters
        ----------
        request : typing.Optional[CreateInternalArticleRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InternalArticle
            internal article created

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom
        from intercom.unstable import CreateInternalArticleRequest

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.internal_articles.create_internal_article(
                request=CreateInternalArticleRequest(
                    title="Thanks for everything",
                    body="Body of the Article",
                    author_id=991266252,
                    owner_id=991266252,
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_internal_article(request=request, request_options=request_options)
        return _response.data

    async def retrieve_internal_article(
        self, id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> InternalArticle:
        """
        You can fetch the details of a single internal article by making a GET request to `https://api.intercom.io/internal_articles/<id>`.

        Parameters
        ----------
        id : int
            The unique identifier for the article which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InternalArticle
            Internal article found

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.internal_articles.retrieve_internal_article(
                id=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve_internal_article(id, request_options=request_options)
        return _response.data

    async def update_internal_article(
        self,
        id: int,
        *,
        title: typing.Optional[str] = OMIT,
        body: typing.Optional[str] = OMIT,
        author_id: typing.Optional[int] = OMIT,
        owner_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> InternalArticle:
        """
        You can update the details of a single internal article by making a PUT request to `https://api.intercom.io/internal_articles/<id>`.

        Parameters
        ----------
        id : int
            The unique identifier for the internal article which is given by Intercom.

        title : typing.Optional[str]
            The title of the article.

        body : typing.Optional[str]
            The content of the article.

        author_id : typing.Optional[int]
            The id of the author of the article.

        owner_id : typing.Optional[int]
            The id of the author of the article.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InternalArticle
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.internal_articles.update_internal_article(
                id=1,
                title="Christmas is here!",
                body="<p>New gifts in store for the jolly season</p>",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_internal_article(
            id, title=title, body=body, author_id=author_id, owner_id=owner_id, request_options=request_options
        )
        return _response.data

    async def delete_internal_article(
        self, id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeletedInternalArticleObject:
        """
        You can delete a single internal article by making a DELETE request to `https://api.intercom.io/internal_articles/<id>`.

        Parameters
        ----------
        id : int
            The unique identifier for the internal article which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeletedInternalArticleObject
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.internal_articles.delete_internal_article(
                id=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_internal_article(id, request_options=request_options)
        return _response.data

    async def search_internal_articles(
        self, *, folder_id: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> InternalArticleSearchResponse:
        """
        You can search for internal articles by making a GET request to `https://api.intercom.io/internal_articles/search`.

        Parameters
        ----------
        folder_id : typing.Optional[str]
            The ID of the folder to search in.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InternalArticleSearchResponse
            Search successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.internal_articles.search_internal_articles(
                folder_id="folder_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.search_internal_articles(
            folder_id=folder_id, request_options=request_options
        )
        return _response.data
