# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel


class InternalArticleListItem(UncheckedBaseModel):
    """
    The data returned about your internal articles when you list them.
    """

    type: typing.Optional[typing.Literal["internal_article"]] = pydantic.Field(default=None)
    """
    The type of object - `internal_article`.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier for the article which is given by Intercom.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    The title of the article.
    """

    body: typing.Optional[str] = pydantic.Field(default=None)
    """
    The body of the article in HTML.
    """

    owner_id: typing.Optional[int] = pydantic.Field(default=None)
    """
    The id of the owner of the article.
    """

    author_id: typing.Optional[int] = pydantic.Field(default=None)
    """
    The id of the author of the article.
    """

    created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time when the article was created.
    """

    updated_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time when the article was last updated.
    """

    locale: typing.Optional[str] = pydantic.Field(default=None)
    """
    The default locale of the article.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
