# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ..types.subscription_type_list import SubscriptionTypeList
from .raw_client import AsyncRawSubscriptionTypesClient, RawSubscriptionTypesClient
from .types.subscription_type import SubscriptionType

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SubscriptionTypesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSubscriptionTypesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSubscriptionTypesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSubscriptionTypesClient
        """
        return self._raw_client

    def attach_subscription_type_to_contact(
        self, contact_id: str, *, id: str, consent_type: str, request_options: typing.Optional[RequestOptions] = None
    ) -> SubscriptionType:
        """
        You can add a specific subscription to a contact. In Intercom, we have two different subscription types based on user consent - opt-out and opt-in:

          1.Attaching a contact to an opt-out subscription type will opt that user out from receiving messages related to that subscription type.

          2.Attaching a contact to an opt-in subscription type will opt that user in to receiving messages related to that subscription type.

        This will return a subscription type model for the subscription type that was added to the contact.

        Parameters
        ----------
        contact_id : str
            The unique identifier for the contact which is given by Intercom

        id : str
            The unique identifier for the subscription which is given by Intercom

        consent_type : str
            The consent_type of a subscription, opt_out or opt_in.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SubscriptionType
            Successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.subscription_types.attach_subscription_type_to_contact(
            contact_id="63a07ddf05a32042dffac965",
            id="37846",
            consent_type="opt_in",
        )
        """
        _response = self._raw_client.attach_subscription_type_to_contact(
            contact_id, id=id, consent_type=consent_type, request_options=request_options
        )
        return _response.data

    def detach_subscription_type_to_contact(
        self, contact_id: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SubscriptionType:
        """
        You can remove a specific subscription from a contact. This will return a subscription type model for the subscription type that was removed from the contact.

        Parameters
        ----------
        contact_id : str
            The unique identifier for the contact which is given by Intercom

        id : str
            The unique identifier for the subscription type which is given by Intercom

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SubscriptionType
            Successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.subscription_types.detach_subscription_type_to_contact(
            contact_id="63a07ddf05a32042dffac965",
            id="37846",
        )
        """
        _response = self._raw_client.detach_subscription_type_to_contact(
            contact_id, id, request_options=request_options
        )
        return _response.data

    def list_subscription_types(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SubscriptionTypeList:
        """
        You can list all subscription types. A list of subscription type objects will be returned.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SubscriptionTypeList
            Successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.subscription_types.list_subscription_types()
        """
        _response = self._raw_client.list_subscription_types(request_options=request_options)
        return _response.data


class AsyncSubscriptionTypesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSubscriptionTypesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSubscriptionTypesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSubscriptionTypesClient
        """
        return self._raw_client

    async def attach_subscription_type_to_contact(
        self, contact_id: str, *, id: str, consent_type: str, request_options: typing.Optional[RequestOptions] = None
    ) -> SubscriptionType:
        """
        You can add a specific subscription to a contact. In Intercom, we have two different subscription types based on user consent - opt-out and opt-in:

          1.Attaching a contact to an opt-out subscription type will opt that user out from receiving messages related to that subscription type.

          2.Attaching a contact to an opt-in subscription type will opt that user in to receiving messages related to that subscription type.

        This will return a subscription type model for the subscription type that was added to the contact.

        Parameters
        ----------
        contact_id : str
            The unique identifier for the contact which is given by Intercom

        id : str
            The unique identifier for the subscription which is given by Intercom

        consent_type : str
            The consent_type of a subscription, opt_out or opt_in.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SubscriptionType
            Successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.subscription_types.attach_subscription_type_to_contact(
                contact_id="63a07ddf05a32042dffac965",
                id="37846",
                consent_type="opt_in",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.attach_subscription_type_to_contact(
            contact_id, id=id, consent_type=consent_type, request_options=request_options
        )
        return _response.data

    async def detach_subscription_type_to_contact(
        self, contact_id: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SubscriptionType:
        """
        You can remove a specific subscription from a contact. This will return a subscription type model for the subscription type that was removed from the contact.

        Parameters
        ----------
        contact_id : str
            The unique identifier for the contact which is given by Intercom

        id : str
            The unique identifier for the subscription type which is given by Intercom

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SubscriptionType
            Successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.subscription_types.detach_subscription_type_to_contact(
                contact_id="63a07ddf05a32042dffac965",
                id="37846",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.detach_subscription_type_to_contact(
            contact_id, id, request_options=request_options
        )
        return _response.data

    async def list_subscription_types(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SubscriptionTypeList:
        """
        You can list all subscription types. A list of subscription type objects will be returned.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SubscriptionTypeList
            Successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.subscription_types.list_subscription_types()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_subscription_types(request_options=request_options)
        return _response.data
