# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ..tickets.types.ticket_type import TicketType
from ..types.ticket_type_list import TicketTypeList
from .raw_client import AsyncRawTicketTypesClient, RawTicketTypesClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TicketTypesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTicketTypesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTicketTypesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTicketTypesClient
        """
        return self._raw_client

    def list_ticket_types(self, *, request_options: typing.Optional[RequestOptions] = None) -> TicketTypeList:
        """
        You can get a list of all ticket types for a workspace.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TicketTypeList
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.ticket_types.list_ticket_types()
        """
        _response = self._raw_client.list_ticket_types(request_options=request_options)
        return _response.data

    def create_ticket_type(
        self, *, request: typing.Any, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[TicketType]:
        """
        You can create a new ticket type.
        > 📘 Creating ticket types.
        >
        > Every ticket type will be created with two default attributes: _default_title_ and _default_description_.
        > For the `icon` propery, use an emoji from [Twemoji Cheatsheet](https://twemoji-cheatsheet.vercel.app/)

        Parameters
        ----------
        request : typing.Any

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[TicketType]
            Ticket type created

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.ticket_types.create_ticket_type(
            request={"key": "value"},
        )
        """
        _response = self._raw_client.create_ticket_type(request=request, request_options=request_options)
        return _response.data

    def get_ticket_type(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[TicketType]:
        """
        You can fetch the details of a single ticket type.

        Parameters
        ----------
        id : str
            The unique identifier for the ticket type which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[TicketType]
            Ticket type found

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.ticket_types.get_ticket_type(
            id="id",
        )
        """
        _response = self._raw_client.get_ticket_type(id, request_options=request_options)
        return _response.data


class AsyncTicketTypesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTicketTypesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTicketTypesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTicketTypesClient
        """
        return self._raw_client

    async def list_ticket_types(self, *, request_options: typing.Optional[RequestOptions] = None) -> TicketTypeList:
        """
        You can get a list of all ticket types for a workspace.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TicketTypeList
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.ticket_types.list_ticket_types()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_ticket_types(request_options=request_options)
        return _response.data

    async def create_ticket_type(
        self, *, request: typing.Any, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[TicketType]:
        """
        You can create a new ticket type.
        > 📘 Creating ticket types.
        >
        > Every ticket type will be created with two default attributes: _default_title_ and _default_description_.
        > For the `icon` propery, use an emoji from [Twemoji Cheatsheet](https://twemoji-cheatsheet.vercel.app/)

        Parameters
        ----------
        request : typing.Any

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[TicketType]
            Ticket type created

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.ticket_types.create_ticket_type(
                request={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_ticket_type(request=request, request_options=request_options)
        return _response.data

    async def get_ticket_type(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[TicketType]:
        """
        You can fetch the details of a single ticket type.

        Parameters
        ----------
        id : str
            The unique identifier for the ticket type which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[TicketType]
            Ticket type found

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.ticket_types.get_ticket_type(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_ticket_type(id, request_options=request_options)
        return _response.data
