# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .activity_log_activity_type import ActivityLogActivityType
from .activity_log_metadata import ActivityLogMetadata
from .activity_log_performed_by import ActivityLogPerformedBy


class ActivityLog(UncheckedBaseModel):
    """
    Activities performed by Admins.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id representing the activity.
    """

    performed_by: typing.Optional[ActivityLogPerformedBy] = pydantic.Field(default=None)
    """
    Details about the Admin involved in the activity.
    """

    metadata: typing.Optional[ActivityLogMetadata] = None
    created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time the activity was created.
    """

    activity_type: typing.Optional[ActivityLogActivityType] = None
    activity_description: typing.Optional[str] = pydantic.Field(default=None)
    """
    A sentence or two describing the activity.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
