# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .article_content_state import ArticleContentState


class ArticleContent(UncheckedBaseModel):
    """
    The Content of an Article.
    """

    type: typing.Optional[typing.Literal["article_content"]] = pydantic.Field(default=None)
    """
    The type of object - `article_content` .
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    The title of the article.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the article.
    """

    body: typing.Optional[str] = pydantic.Field(default=None)
    """
    The body of the article.
    """

    author_id: typing.Optional[int] = pydantic.Field(default=None)
    """
    The ID of the author of the article.
    """

    state: typing.Optional[ArticleContentState] = pydantic.Field(default=None)
    """
    Whether the article is `published` or is a `draft` .
    """

    created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time when the article was created (seconds).
    """

    updated_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time when the article was last updated (seconds).
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The URL of the article.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
