# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .conversation_sla_paused_current_sla_status import ConversationSlaPausedCurrentSlaStatus
from .conversation_sla_paused_sla_states_value import ConversationSlaPausedSlaStatesValue


class ConversationSlaPaused(UncheckedBaseModel):
    """
    Contains SLA status at the moment of pausing for conversation part type <code>conversation_sla_paused</code>.
    """

    sla_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the SLA being paused
    """

    current_sla_status: typing.Optional[ConversationSlaPausedCurrentSlaStatus] = pydantic.Field(default=None)
    """
    Overall SLA status at pause time
    """

    sla_states: typing.Optional[typing.Dict[str, ConversationSlaPausedSlaStatesValue]] = pydantic.Field(default=None)
    """
    Status of all SLA targets at pause time
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
