# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .conversation_sla_target_missed_current_sla_status import ConversationSlaTargetMissedCurrentSlaStatus
from .conversation_sla_target_missed_sla_states_value import ConversationSlaTargetMissedSlaStatesValue
from .conversation_sla_target_missed_sla_target_type import ConversationSlaTargetMissedSlaTargetType


class ConversationSlaTargetMissed(UncheckedBaseModel):
    """
    Contains complete status of all SLA targets when a breach occurs for conversation part type <code>conversation_sla_target_missed</code>.
    """

    sla_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the SLA
    """

    sla_target_type: typing.Optional[ConversationSlaTargetMissedSlaTargetType] = pydantic.Field(default=None)
    """
    Which specific target was missed
    """

    current_sla_status: typing.Optional[ConversationSlaTargetMissedCurrentSlaStatus] = pydantic.Field(default=None)
    """
    Overall SLA status
    """

    sla_states: typing.Optional[typing.Dict[str, ConversationSlaTargetMissedSlaStatesValue]] = pydantic.Field(
        default=None
    )
    """
    Status of all SLA targets at the time of breach
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
