# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .create_ticket_type_request_category import CreateTicketTypeRequestCategory


class CreateTicketTypeRequest(UncheckedBaseModel):
    """
    The request payload for creating a ticket type.
      You can copy the `icon` property for your ticket type from [Twemoji Cheatsheet](https://twemoji-cheatsheet.vercel.app/)
    """

    name: str = pydantic.Field()
    """
    The name of the ticket type.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the ticket type.
    """

    category: typing.Optional[CreateTicketTypeRequestCategory] = pydantic.Field(default=None)
    """
    Category of the Ticket Type.
    """

    icon: typing.Optional[str] = pydantic.Field(default=None)
    """
    The icon of the ticket type.
    """

    is_internal: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the tickets associated with this ticket type are intended for internal use only or will be shared with customers. This is currently a limited attribute.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
