# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel, UnionMetadata
from ..news.types.news_item_state import NewsItemState
from ..news.types.newsfeed_assignment import NewsfeedAssignment


class PaginatedResponseDataItem_NewsItem(UncheckedBaseModel):
    type: typing.Literal["news-item"] = "news-item"
    id: typing.Optional[str] = None
    workspace_id: typing.Optional[str] = None
    title: typing.Optional[str] = None
    body: typing.Optional[str] = None
    sender_id: typing.Optional[int] = None
    state: typing.Optional[NewsItemState] = None
    newsfeed_assignments: typing.Optional[typing.List[NewsfeedAssignment]] = None
    labels: typing.Optional[typing.List[typing.Optional[str]]] = None
    cover_image_url: typing.Optional[str] = None
    reactions: typing.Optional[typing.List[typing.Optional[str]]] = None
    deliver_silently: typing.Optional[bool] = None
    created_at: typing.Optional[int] = None
    updated_at: typing.Optional[int] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class PaginatedResponseDataItem_Newsfeed(UncheckedBaseModel):
    type: typing.Literal["newsfeed"] = "newsfeed"
    id: typing.Optional[str] = None
    name: typing.Optional[str] = None
    created_at: typing.Optional[int] = None
    updated_at: typing.Optional[int] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


PaginatedResponseDataItem = typing_extensions.Annotated[
    typing.Union[PaginatedResponseDataItem_NewsItem, PaginatedResponseDataItem_Newsfeed],
    UnionMetadata(discriminant="type"),
]
