# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .sla_applied_sla_status import SlaAppliedSlaStatus


class SlaApplied(UncheckedBaseModel):
    """
    The SLA Applied object contains the details for which SLA has been applied to this conversation.
    Important: if there are any canceled sla_events for the conversation - meaning an SLA has been manually removed from a conversation, the sla_status will always be returned as null.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    object type
    """

    sla_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the SLA as given by the teammate when it was created.
    """

    sla_status: typing.Optional[SlaAppliedSlaStatus] = pydantic.Field(default=None)
    """
    SLA statuses:
                - `hit`: If there’s at least one hit event in the underlying sla_events table, and no “missed” or “canceled” events for the conversation.
                - `missed`: If there are any missed sla_events for the conversation and no canceled events. If there’s even a single missed sla event, the status will always be missed. A missed status is not applied when the SLA expires, only the next time a teammate replies.
                - `active`: An SLA has been applied to a conversation, but has not yet been fulfilled. SLA status is active only if there are no “hit, “missed”, or “canceled” events.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
