# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .workflow_export_workflow_state import WorkflowExportWorkflowState


class WorkflowExportWorkflow(UncheckedBaseModel):
    """
    The workflow configuration.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier for the workflow.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    The title of the workflow.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the workflow.
    """

    trigger_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of trigger that starts this workflow.
    """

    state: typing.Optional[WorkflowExportWorkflowState] = pydantic.Field(default=None)
    """
    The current state of the workflow.
    """

    target_channels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The channels this workflow targets.
    """

    preferred_devices: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The preferred devices for this workflow.
    """

    created_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the workflow was created.
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    When the workflow was last updated.
    """

    targeting: typing.Optional[typing.Dict[str, typing.Any]] = pydantic.Field(default=None)
    """
    The targeting rules for this workflow.
    """

    snapshot: typing.Optional[typing.Dict[str, typing.Any]] = pydantic.Field(default=None)
    """
    The current snapshot of workflow steps and configuration.
    """

    attributes: typing.Optional[typing.List[typing.Dict[str, typing.Any]]] = pydantic.Field(default=None)
    """
    Custom attributes defined for this workflow.
    """

    embedded_rules: typing.Optional[typing.List[typing.Dict[str, typing.Any]]] = pydantic.Field(default=None)
    """
    Rules embedded within the workflow steps.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
