# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ..types.workflow_export import WorkflowExport
from .raw_client import AsyncRawWorkflowsClient, RawWorkflowsClient


class WorkflowsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWorkflowsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawWorkflowsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWorkflowsClient
        """
        return self._raw_client

    def export_workflow(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> WorkflowExport:
        """
        Export a workflow configuration by its ID. This endpoint returns the complete workflow definition including its steps, targeting rules, and attributes.

        This endpoint is designed for EU Data Act compliance, allowing customers to export their workflow configurations.

        {% admonition type="warning" name="Unstable API" %}
          This API is currently in the Unstable version. Its behavior may change in future releases.
        {% /admonition %}

        Parameters
        ----------
        id : str
            The unique identifier for the workflow

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowExport
            Workflow exported successfully

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.workflows.export_workflow(
            id="12345",
        )
        """
        _response = self._raw_client.export_workflow(id, request_options=request_options)
        return _response.data


class AsyncWorkflowsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWorkflowsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawWorkflowsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWorkflowsClient
        """
        return self._raw_client

    async def export_workflow(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WorkflowExport:
        """
        Export a workflow configuration by its ID. This endpoint returns the complete workflow definition including its steps, targeting rules, and attributes.

        This endpoint is designed for EU Data Act compliance, allowing customers to export their workflow configurations.

        {% admonition type="warning" name="Unstable API" %}
          This API is currently in the Unstable version. Its behavior may change in future releases.
        {% /admonition %}

        Parameters
        ----------
        id : str
            The unique identifier for the workflow

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WorkflowExport
            Workflow exported successfully

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.workflows.export_workflow(
                id="12345",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.export_workflow(id, request_options=request_options)
        return _response.data
