# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .content_import_source_status import ContentImportSourceStatus
from .content_import_source_sync_behavior import ContentImportSourceSyncBehavior


class ContentImportSource(UncheckedBaseModel):
    """
    An external source for External Pages that you add to your Fin Content Library.
    """

    type: typing.Literal["content_import_source"] = pydantic.Field(default="content_import_source")
    """
    Always external_page
    """

    id: int = pydantic.Field()
    """
    The unique identifier for the content import source which is given by Intercom.
    """

    last_synced_at: int = pydantic.Field()
    """
    The time when the content import source was last synced.
    """

    sync_behavior: ContentImportSourceSyncBehavior = pydantic.Field()
    """
    If you intend to create or update External Pages via the API, this should be set to `api`.
    """

    status: ContentImportSourceStatus = pydantic.Field()
    """
    The status of the content import source.
    """

    url: str = pydantic.Field()
    """
    The URL of the root of the external source.
    """

    created_at: int = pydantic.Field()
    """
    The time when the content import source was created.
    """

    updated_at: int = pydantic.Field()
    """
    The time when the content import source was last updated.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
