# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.call_list import CallList
from .raw_client import AsyncRawCallsClient, RawCallsClient
from .types.call import Call
from .types.list_calls_with_transcripts_response import ListCallsWithTranscriptsResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CallsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCallsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCallsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCallsClient
        """
        return self._raw_client

    def list_calls(
        self,
        *,
        page: typing.Optional[int] = None,
        per_page: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CallList:
        """
        Retrieve a paginated list of calls.

        Parameters
        ----------
        page : typing.Optional[int]
            The page of results to fetch. Defaults to first page

        per_page : typing.Optional[int]
            How many results to display per page. Defaults to 25. Max 25.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CallList
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.calls.list_calls(
            page=1,
            per_page=1,
        )
        """
        _response = self._raw_client.list_calls(page=page, per_page=per_page, request_options=request_options)
        return _response.data

    def show_call(self, call_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Call:
        """
        Retrieve a single call by id.

        Parameters
        ----------
        call_id : str
            The id of the call to retrieve

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Call
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.calls.show_call(
            call_id="call_id",
        )
        """
        _response = self._raw_client.show_call(call_id, request_options=request_options)
        return _response.data

    def show_call_recording(self, call_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> None:
        """
        Redirects to a signed URL for the call's recording if it exists.

        Parameters
        ----------
        call_id : str
            The id of the call

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.calls.show_call_recording(
            call_id="call_id",
        )
        """
        _response = self._raw_client.show_call_recording(call_id, request_options=request_options)
        return _response.data

    def show_call_transcript(self, call_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> str:
        """
        Returns the transcript for the specified call as a downloadable text file.

        Parameters
        ----------
        call_id : str
            The id of the call

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        str
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.calls.show_call_transcript(
            call_id="call_id",
        )
        """
        _response = self._raw_client.show_call_transcript(call_id, request_options=request_options)
        return _response.data

    def list_calls_with_transcripts(
        self, *, conversation_ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> ListCallsWithTranscriptsResponse:
        """
        Retrieve calls by a list of conversation ids and include transcripts when available.
        A maximum of 20 `conversation_ids` can be provided. If none are provided or more than 20 are provided, a 400 error is returned.

        Parameters
        ----------
        conversation_ids : typing.Sequence[str]
            A list of conversation ids to fetch calls for. Maximum 20.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListCallsWithTranscriptsResponse
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.calls.list_calls_with_transcripts(
            conversation_ids=["64619700005694", "64619700005695"],
        )
        """
        _response = self._raw_client.list_calls_with_transcripts(
            conversation_ids=conversation_ids, request_options=request_options
        )
        return _response.data


class AsyncCallsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCallsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCallsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCallsClient
        """
        return self._raw_client

    async def list_calls(
        self,
        *,
        page: typing.Optional[int] = None,
        per_page: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CallList:
        """
        Retrieve a paginated list of calls.

        Parameters
        ----------
        page : typing.Optional[int]
            The page of results to fetch. Defaults to first page

        per_page : typing.Optional[int]
            How many results to display per page. Defaults to 25. Max 25.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CallList
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.calls.list_calls(
                page=1,
                per_page=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_calls(page=page, per_page=per_page, request_options=request_options)
        return _response.data

    async def show_call(self, call_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Call:
        """
        Retrieve a single call by id.

        Parameters
        ----------
        call_id : str
            The id of the call to retrieve

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Call
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.calls.show_call(
                call_id="call_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.show_call(call_id, request_options=request_options)
        return _response.data

    async def show_call_recording(
        self, call_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Redirects to a signed URL for the call's recording if it exists.

        Parameters
        ----------
        call_id : str
            The id of the call

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.calls.show_call_recording(
                call_id="call_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.show_call_recording(call_id, request_options=request_options)
        return _response.data

    async def show_call_transcript(
        self, call_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> str:
        """
        Returns the transcript for the specified call as a downloadable text file.

        Parameters
        ----------
        call_id : str
            The id of the call

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        str
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.calls.show_call_transcript(
                call_id="call_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.show_call_transcript(call_id, request_options=request_options)
        return _response.data

    async def list_calls_with_transcripts(
        self, *, conversation_ids: typing.Sequence[str], request_options: typing.Optional[RequestOptions] = None
    ) -> ListCallsWithTranscriptsResponse:
        """
        Retrieve calls by a list of conversation ids and include transcripts when available.
        A maximum of 20 `conversation_ids` can be provided. If none are provided or more than 20 are provided, a 400 error is returned.

        Parameters
        ----------
        conversation_ids : typing.Sequence[str]
            A list of conversation ids to fetch calls for. Maximum 20.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListCallsWithTranscriptsResponse
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.calls.list_calls_with_transcripts(
                conversation_ids=["64619700005694", "64619700005695"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_calls_with_transcripts(
            conversation_ids=conversation_ids, request_options=request_options
        )
        return _response.data
