# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import os
import typing

import httpx
from .core.api_error import ApiError
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .environment import IntercomEnvironment

if typing.TYPE_CHECKING:
    from .admins.client import AdminsClient, AsyncAdminsClient
    from .ai_content.client import AiContentClient, AsyncAiContentClient
    from .articles.client import ArticlesClient, AsyncArticlesClient
    from .away_status_reasons.client import AsyncAwayStatusReasonsClient, AwayStatusReasonsClient
    from .calls.client import AsyncCallsClient, CallsClient
    from .companies.client import AsyncCompaniesClient, CompaniesClient
    from .contacts.client import AsyncContactsClient, ContactsClient
    from .conversations.client import AsyncConversationsClient, ConversationsClient
    from .custom_channel_events.client import AsyncCustomChannelEventsClient, CustomChannelEventsClient
    from .custom_object_instances.client import AsyncCustomObjectInstancesClient, CustomObjectInstancesClient
    from .data_attributes.client import AsyncDataAttributesClient, DataAttributesClient
    from .data_export.client import AsyncDataExportClient, DataExportClient
    from .events.client import AsyncEventsClient, EventsClient
    from .export.client import AsyncExportClient, ExportClient
    from .help_centers.client import AsyncHelpCentersClient, HelpCentersClient
    from .internal_articles.client import AsyncInternalArticlesClient, InternalArticlesClient
    from .ip_allowlist.client import AsyncIpAllowlistClient, IpAllowlistClient
    from .jobs.client import AsyncJobsClient, JobsClient
    from .messages.client import AsyncMessagesClient, MessagesClient
    from .news.client import AsyncNewsClient, NewsClient
    from .notes.client import AsyncNotesClient, NotesClient
    from .phone_call_redirects.client import AsyncPhoneCallRedirectsClient, PhoneCallRedirectsClient
    from .segments.client import AsyncSegmentsClient, SegmentsClient
    from .subscription_types.client import AsyncSubscriptionTypesClient, SubscriptionTypesClient
    from .tags.client import AsyncTagsClient, TagsClient
    from .teams.client import AsyncTeamsClient, TeamsClient
    from .ticket_states.client import AsyncTicketStatesClient, TicketStatesClient
    from .ticket_types.client import AsyncTicketTypesClient, TicketTypesClient
    from .tickets.client import AsyncTicketsClient, TicketsClient
    from .unstable.client import AsyncUnstableClient, UnstableClient
    from .visitors.client import AsyncVisitorsClient, VisitorsClient


class Intercom:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : IntercomEnvironment
        The environment to use for requests from the client. from .environment import IntercomEnvironment



        Defaults to IntercomEnvironment.US_PRODUCTION



    token : typing.Optional[typing.Union[str, typing.Callable[[], str]]]
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from intercom import Intercom

    client = Intercom(
        token="YOUR_TOKEN",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: IntercomEnvironment = IntercomEnvironment.US_PRODUCTION,
        token: typing.Optional[typing.Union[str, typing.Callable[[], str]]] = os.getenv("INTERCOM_API_KEY"),
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        if token is None:
            raise ApiError(
                body="The client must be instantiated be either passing in token or setting INTERCOM_API_KEY"
            )
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            token=token,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._admins: typing.Optional[AdminsClient] = None
        self._ai_content: typing.Optional[AiContentClient] = None
        self._articles: typing.Optional[ArticlesClient] = None
        self._away_status_reasons: typing.Optional[AwayStatusReasonsClient] = None
        self._export: typing.Optional[ExportClient] = None
        self._data_export: typing.Optional[DataExportClient] = None
        self._help_centers: typing.Optional[HelpCentersClient] = None
        self._internal_articles: typing.Optional[InternalArticlesClient] = None
        self._ip_allowlist: typing.Optional[IpAllowlistClient] = None
        self._companies: typing.Optional[CompaniesClient] = None
        self._contacts: typing.Optional[ContactsClient] = None
        self._notes: typing.Optional[NotesClient] = None
        self._tags: typing.Optional[TagsClient] = None
        self._conversations: typing.Optional[ConversationsClient] = None
        self._custom_channel_events: typing.Optional[CustomChannelEventsClient] = None
        self._custom_object_instances: typing.Optional[CustomObjectInstancesClient] = None
        self._data_attributes: typing.Optional[DataAttributesClient] = None
        self._events: typing.Optional[EventsClient] = None
        self._jobs: typing.Optional[JobsClient] = None
        self._messages: typing.Optional[MessagesClient] = None
        self._segments: typing.Optional[SegmentsClient] = None
        self._subscription_types: typing.Optional[SubscriptionTypesClient] = None
        self._phone_call_redirects: typing.Optional[PhoneCallRedirectsClient] = None
        self._calls: typing.Optional[CallsClient] = None
        self._teams: typing.Optional[TeamsClient] = None
        self._ticket_states: typing.Optional[TicketStatesClient] = None
        self._ticket_types: typing.Optional[TicketTypesClient] = None
        self._tickets: typing.Optional[TicketsClient] = None
        self._visitors: typing.Optional[VisitorsClient] = None
        self._news: typing.Optional[NewsClient] = None
        self._unstable: typing.Optional[UnstableClient] = None

    @property
    def admins(self):
        if self._admins is None:
            from .admins.client import AdminsClient  # noqa: E402

            self._admins = AdminsClient(client_wrapper=self._client_wrapper)
        return self._admins

    @property
    def ai_content(self):
        if self._ai_content is None:
            from .ai_content.client import AiContentClient  # noqa: E402

            self._ai_content = AiContentClient(client_wrapper=self._client_wrapper)
        return self._ai_content

    @property
    def articles(self):
        if self._articles is None:
            from .articles.client import ArticlesClient  # noqa: E402

            self._articles = ArticlesClient(client_wrapper=self._client_wrapper)
        return self._articles

    @property
    def away_status_reasons(self):
        if self._away_status_reasons is None:
            from .away_status_reasons.client import AwayStatusReasonsClient  # noqa: E402

            self._away_status_reasons = AwayStatusReasonsClient(client_wrapper=self._client_wrapper)
        return self._away_status_reasons

    @property
    def export(self):
        if self._export is None:
            from .export.client import ExportClient  # noqa: E402

            self._export = ExportClient(client_wrapper=self._client_wrapper)
        return self._export

    @property
    def data_export(self):
        if self._data_export is None:
            from .data_export.client import DataExportClient  # noqa: E402

            self._data_export = DataExportClient(client_wrapper=self._client_wrapper)
        return self._data_export

    @property
    def help_centers(self):
        if self._help_centers is None:
            from .help_centers.client import HelpCentersClient  # noqa: E402

            self._help_centers = HelpCentersClient(client_wrapper=self._client_wrapper)
        return self._help_centers

    @property
    def internal_articles(self):
        if self._internal_articles is None:
            from .internal_articles.client import InternalArticlesClient  # noqa: E402

            self._internal_articles = InternalArticlesClient(client_wrapper=self._client_wrapper)
        return self._internal_articles

    @property
    def ip_allowlist(self):
        if self._ip_allowlist is None:
            from .ip_allowlist.client import IpAllowlistClient  # noqa: E402

            self._ip_allowlist = IpAllowlistClient(client_wrapper=self._client_wrapper)
        return self._ip_allowlist

    @property
    def companies(self):
        if self._companies is None:
            from .companies.client import CompaniesClient  # noqa: E402

            self._companies = CompaniesClient(client_wrapper=self._client_wrapper)
        return self._companies

    @property
    def contacts(self):
        if self._contacts is None:
            from .contacts.client import ContactsClient  # noqa: E402

            self._contacts = ContactsClient(client_wrapper=self._client_wrapper)
        return self._contacts

    @property
    def notes(self):
        if self._notes is None:
            from .notes.client import NotesClient  # noqa: E402

            self._notes = NotesClient(client_wrapper=self._client_wrapper)
        return self._notes

    @property
    def tags(self):
        if self._tags is None:
            from .tags.client import TagsClient  # noqa: E402

            self._tags = TagsClient(client_wrapper=self._client_wrapper)
        return self._tags

    @property
    def conversations(self):
        if self._conversations is None:
            from .conversations.client import ConversationsClient  # noqa: E402

            self._conversations = ConversationsClient(client_wrapper=self._client_wrapper)
        return self._conversations

    @property
    def custom_channel_events(self):
        if self._custom_channel_events is None:
            from .custom_channel_events.client import CustomChannelEventsClient  # noqa: E402

            self._custom_channel_events = CustomChannelEventsClient(client_wrapper=self._client_wrapper)
        return self._custom_channel_events

    @property
    def custom_object_instances(self):
        if self._custom_object_instances is None:
            from .custom_object_instances.client import CustomObjectInstancesClient  # noqa: E402

            self._custom_object_instances = CustomObjectInstancesClient(client_wrapper=self._client_wrapper)
        return self._custom_object_instances

    @property
    def data_attributes(self):
        if self._data_attributes is None:
            from .data_attributes.client import DataAttributesClient  # noqa: E402

            self._data_attributes = DataAttributesClient(client_wrapper=self._client_wrapper)
        return self._data_attributes

    @property
    def events(self):
        if self._events is None:
            from .events.client import EventsClient  # noqa: E402

            self._events = EventsClient(client_wrapper=self._client_wrapper)
        return self._events

    @property
    def jobs(self):
        if self._jobs is None:
            from .jobs.client import JobsClient  # noqa: E402

            self._jobs = JobsClient(client_wrapper=self._client_wrapper)
        return self._jobs

    @property
    def messages(self):
        if self._messages is None:
            from .messages.client import MessagesClient  # noqa: E402

            self._messages = MessagesClient(client_wrapper=self._client_wrapper)
        return self._messages

    @property
    def segments(self):
        if self._segments is None:
            from .segments.client import SegmentsClient  # noqa: E402

            self._segments = SegmentsClient(client_wrapper=self._client_wrapper)
        return self._segments

    @property
    def subscription_types(self):
        if self._subscription_types is None:
            from .subscription_types.client import SubscriptionTypesClient  # noqa: E402

            self._subscription_types = SubscriptionTypesClient(client_wrapper=self._client_wrapper)
        return self._subscription_types

    @property
    def phone_call_redirects(self):
        if self._phone_call_redirects is None:
            from .phone_call_redirects.client import PhoneCallRedirectsClient  # noqa: E402

            self._phone_call_redirects = PhoneCallRedirectsClient(client_wrapper=self._client_wrapper)
        return self._phone_call_redirects

    @property
    def calls(self):
        if self._calls is None:
            from .calls.client import CallsClient  # noqa: E402

            self._calls = CallsClient(client_wrapper=self._client_wrapper)
        return self._calls

    @property
    def teams(self):
        if self._teams is None:
            from .teams.client import TeamsClient  # noqa: E402

            self._teams = TeamsClient(client_wrapper=self._client_wrapper)
        return self._teams

    @property
    def ticket_states(self):
        if self._ticket_states is None:
            from .ticket_states.client import TicketStatesClient  # noqa: E402

            self._ticket_states = TicketStatesClient(client_wrapper=self._client_wrapper)
        return self._ticket_states

    @property
    def ticket_types(self):
        if self._ticket_types is None:
            from .ticket_types.client import TicketTypesClient  # noqa: E402

            self._ticket_types = TicketTypesClient(client_wrapper=self._client_wrapper)
        return self._ticket_types

    @property
    def tickets(self):
        if self._tickets is None:
            from .tickets.client import TicketsClient  # noqa: E402

            self._tickets = TicketsClient(client_wrapper=self._client_wrapper)
        return self._tickets

    @property
    def visitors(self):
        if self._visitors is None:
            from .visitors.client import VisitorsClient  # noqa: E402

            self._visitors = VisitorsClient(client_wrapper=self._client_wrapper)
        return self._visitors

    @property
    def news(self):
        if self._news is None:
            from .news.client import NewsClient  # noqa: E402

            self._news = NewsClient(client_wrapper=self._client_wrapper)
        return self._news

    @property
    def unstable(self):
        if self._unstable is None:
            from .unstable.client import UnstableClient  # noqa: E402

            self._unstable = UnstableClient(client_wrapper=self._client_wrapper)
        return self._unstable


class AsyncIntercom:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : IntercomEnvironment
        The environment to use for requests from the client. from .environment import IntercomEnvironment



        Defaults to IntercomEnvironment.US_PRODUCTION



    token : typing.Optional[typing.Union[str, typing.Callable[[], str]]]
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from intercom import AsyncIntercom

    client = AsyncIntercom(
        token="YOUR_TOKEN",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: IntercomEnvironment = IntercomEnvironment.US_PRODUCTION,
        token: typing.Optional[typing.Union[str, typing.Callable[[], str]]] = os.getenv("INTERCOM_API_KEY"),
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        if token is None:
            raise ApiError(
                body="The client must be instantiated be either passing in token or setting INTERCOM_API_KEY"
            )
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            token=token,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._admins: typing.Optional[AsyncAdminsClient] = None
        self._ai_content: typing.Optional[AsyncAiContentClient] = None
        self._articles: typing.Optional[AsyncArticlesClient] = None
        self._away_status_reasons: typing.Optional[AsyncAwayStatusReasonsClient] = None
        self._export: typing.Optional[AsyncExportClient] = None
        self._data_export: typing.Optional[AsyncDataExportClient] = None
        self._help_centers: typing.Optional[AsyncHelpCentersClient] = None
        self._internal_articles: typing.Optional[AsyncInternalArticlesClient] = None
        self._ip_allowlist: typing.Optional[AsyncIpAllowlistClient] = None
        self._companies: typing.Optional[AsyncCompaniesClient] = None
        self._contacts: typing.Optional[AsyncContactsClient] = None
        self._notes: typing.Optional[AsyncNotesClient] = None
        self._tags: typing.Optional[AsyncTagsClient] = None
        self._conversations: typing.Optional[AsyncConversationsClient] = None
        self._custom_channel_events: typing.Optional[AsyncCustomChannelEventsClient] = None
        self._custom_object_instances: typing.Optional[AsyncCustomObjectInstancesClient] = None
        self._data_attributes: typing.Optional[AsyncDataAttributesClient] = None
        self._events: typing.Optional[AsyncEventsClient] = None
        self._jobs: typing.Optional[AsyncJobsClient] = None
        self._messages: typing.Optional[AsyncMessagesClient] = None
        self._segments: typing.Optional[AsyncSegmentsClient] = None
        self._subscription_types: typing.Optional[AsyncSubscriptionTypesClient] = None
        self._phone_call_redirects: typing.Optional[AsyncPhoneCallRedirectsClient] = None
        self._calls: typing.Optional[AsyncCallsClient] = None
        self._teams: typing.Optional[AsyncTeamsClient] = None
        self._ticket_states: typing.Optional[AsyncTicketStatesClient] = None
        self._ticket_types: typing.Optional[AsyncTicketTypesClient] = None
        self._tickets: typing.Optional[AsyncTicketsClient] = None
        self._visitors: typing.Optional[AsyncVisitorsClient] = None
        self._news: typing.Optional[AsyncNewsClient] = None
        self._unstable: typing.Optional[AsyncUnstableClient] = None

    @property
    def admins(self):
        if self._admins is None:
            from .admins.client import AsyncAdminsClient  # noqa: E402

            self._admins = AsyncAdminsClient(client_wrapper=self._client_wrapper)
        return self._admins

    @property
    def ai_content(self):
        if self._ai_content is None:
            from .ai_content.client import AsyncAiContentClient  # noqa: E402

            self._ai_content = AsyncAiContentClient(client_wrapper=self._client_wrapper)
        return self._ai_content

    @property
    def articles(self):
        if self._articles is None:
            from .articles.client import AsyncArticlesClient  # noqa: E402

            self._articles = AsyncArticlesClient(client_wrapper=self._client_wrapper)
        return self._articles

    @property
    def away_status_reasons(self):
        if self._away_status_reasons is None:
            from .away_status_reasons.client import AsyncAwayStatusReasonsClient  # noqa: E402

            self._away_status_reasons = AsyncAwayStatusReasonsClient(client_wrapper=self._client_wrapper)
        return self._away_status_reasons

    @property
    def export(self):
        if self._export is None:
            from .export.client import AsyncExportClient  # noqa: E402

            self._export = AsyncExportClient(client_wrapper=self._client_wrapper)
        return self._export

    @property
    def data_export(self):
        if self._data_export is None:
            from .data_export.client import AsyncDataExportClient  # noqa: E402

            self._data_export = AsyncDataExportClient(client_wrapper=self._client_wrapper)
        return self._data_export

    @property
    def help_centers(self):
        if self._help_centers is None:
            from .help_centers.client import AsyncHelpCentersClient  # noqa: E402

            self._help_centers = AsyncHelpCentersClient(client_wrapper=self._client_wrapper)
        return self._help_centers

    @property
    def internal_articles(self):
        if self._internal_articles is None:
            from .internal_articles.client import AsyncInternalArticlesClient  # noqa: E402

            self._internal_articles = AsyncInternalArticlesClient(client_wrapper=self._client_wrapper)
        return self._internal_articles

    @property
    def ip_allowlist(self):
        if self._ip_allowlist is None:
            from .ip_allowlist.client import AsyncIpAllowlistClient  # noqa: E402

            self._ip_allowlist = AsyncIpAllowlistClient(client_wrapper=self._client_wrapper)
        return self._ip_allowlist

    @property
    def companies(self):
        if self._companies is None:
            from .companies.client import AsyncCompaniesClient  # noqa: E402

            self._companies = AsyncCompaniesClient(client_wrapper=self._client_wrapper)
        return self._companies

    @property
    def contacts(self):
        if self._contacts is None:
            from .contacts.client import AsyncContactsClient  # noqa: E402

            self._contacts = AsyncContactsClient(client_wrapper=self._client_wrapper)
        return self._contacts

    @property
    def notes(self):
        if self._notes is None:
            from .notes.client import AsyncNotesClient  # noqa: E402

            self._notes = AsyncNotesClient(client_wrapper=self._client_wrapper)
        return self._notes

    @property
    def tags(self):
        if self._tags is None:
            from .tags.client import AsyncTagsClient  # noqa: E402

            self._tags = AsyncTagsClient(client_wrapper=self._client_wrapper)
        return self._tags

    @property
    def conversations(self):
        if self._conversations is None:
            from .conversations.client import AsyncConversationsClient  # noqa: E402

            self._conversations = AsyncConversationsClient(client_wrapper=self._client_wrapper)
        return self._conversations

    @property
    def custom_channel_events(self):
        if self._custom_channel_events is None:
            from .custom_channel_events.client import AsyncCustomChannelEventsClient  # noqa: E402

            self._custom_channel_events = AsyncCustomChannelEventsClient(client_wrapper=self._client_wrapper)
        return self._custom_channel_events

    @property
    def custom_object_instances(self):
        if self._custom_object_instances is None:
            from .custom_object_instances.client import AsyncCustomObjectInstancesClient  # noqa: E402

            self._custom_object_instances = AsyncCustomObjectInstancesClient(client_wrapper=self._client_wrapper)
        return self._custom_object_instances

    @property
    def data_attributes(self):
        if self._data_attributes is None:
            from .data_attributes.client import AsyncDataAttributesClient  # noqa: E402

            self._data_attributes = AsyncDataAttributesClient(client_wrapper=self._client_wrapper)
        return self._data_attributes

    @property
    def events(self):
        if self._events is None:
            from .events.client import AsyncEventsClient  # noqa: E402

            self._events = AsyncEventsClient(client_wrapper=self._client_wrapper)
        return self._events

    @property
    def jobs(self):
        if self._jobs is None:
            from .jobs.client import AsyncJobsClient  # noqa: E402

            self._jobs = AsyncJobsClient(client_wrapper=self._client_wrapper)
        return self._jobs

    @property
    def messages(self):
        if self._messages is None:
            from .messages.client import AsyncMessagesClient  # noqa: E402

            self._messages = AsyncMessagesClient(client_wrapper=self._client_wrapper)
        return self._messages

    @property
    def segments(self):
        if self._segments is None:
            from .segments.client import AsyncSegmentsClient  # noqa: E402

            self._segments = AsyncSegmentsClient(client_wrapper=self._client_wrapper)
        return self._segments

    @property
    def subscription_types(self):
        if self._subscription_types is None:
            from .subscription_types.client import AsyncSubscriptionTypesClient  # noqa: E402

            self._subscription_types = AsyncSubscriptionTypesClient(client_wrapper=self._client_wrapper)
        return self._subscription_types

    @property
    def phone_call_redirects(self):
        if self._phone_call_redirects is None:
            from .phone_call_redirects.client import AsyncPhoneCallRedirectsClient  # noqa: E402

            self._phone_call_redirects = AsyncPhoneCallRedirectsClient(client_wrapper=self._client_wrapper)
        return self._phone_call_redirects

    @property
    def calls(self):
        if self._calls is None:
            from .calls.client import AsyncCallsClient  # noqa: E402

            self._calls = AsyncCallsClient(client_wrapper=self._client_wrapper)
        return self._calls

    @property
    def teams(self):
        if self._teams is None:
            from .teams.client import AsyncTeamsClient  # noqa: E402

            self._teams = AsyncTeamsClient(client_wrapper=self._client_wrapper)
        return self._teams

    @property
    def ticket_states(self):
        if self._ticket_states is None:
            from .ticket_states.client import AsyncTicketStatesClient  # noqa: E402

            self._ticket_states = AsyncTicketStatesClient(client_wrapper=self._client_wrapper)
        return self._ticket_states

    @property
    def ticket_types(self):
        if self._ticket_types is None:
            from .ticket_types.client import AsyncTicketTypesClient  # noqa: E402

            self._ticket_types = AsyncTicketTypesClient(client_wrapper=self._client_wrapper)
        return self._ticket_types

    @property
    def tickets(self):
        if self._tickets is None:
            from .tickets.client import AsyncTicketsClient  # noqa: E402

            self._tickets = AsyncTicketsClient(client_wrapper=self._client_wrapper)
        return self._tickets

    @property
    def visitors(self):
        if self._visitors is None:
            from .visitors.client import AsyncVisitorsClient  # noqa: E402

            self._visitors = AsyncVisitorsClient(client_wrapper=self._client_wrapper)
        return self._visitors

    @property
    def news(self):
        if self._news is None:
            from .news.client import AsyncNewsClient  # noqa: E402

            self._news = AsyncNewsClient(client_wrapper=self._client_wrapper)
        return self._news

    @property
    def unstable(self):
        if self._unstable is None:
            from .unstable.client import AsyncUnstableClient  # noqa: E402

            self._unstable = AsyncUnstableClient(client_wrapper=self._client_wrapper)
        return self._unstable


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: IntercomEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
