# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel, UnionMetadata
from ...types.offset_pages import OffsetPages
from .company import Company
from .company_plan import CompanyPlan
from .company_segments import CompanySegments
from .company_tags import CompanyTags


class CompaniesRetrieveResponse_Company(UncheckedBaseModel):
    type: typing.Literal["company"] = "company"
    id: str
    name: str
    app_id: str
    plan: typing.Optional[CompanyPlan] = None
    company_id: str
    remote_created_at: typing.Optional[int] = None
    created_at: int
    updated_at: int
    last_request_at: typing.Optional[int] = None
    size: typing.Optional[int] = None
    website: typing.Optional[str] = None
    industry: typing.Optional[str] = None
    monthly_spend: int
    session_count: int
    user_count: int
    custom_attributes: typing.Optional[typing.Dict[str, typing.Any]] = None
    tags: typing.Optional[CompanyTags] = None
    segments: typing.Optional[CompanySegments] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class CompaniesRetrieveResponse_List(UncheckedBaseModel):
    type: typing.Literal["list"] = "list"
    pages: typing.Optional[OffsetPages] = None
    total_count: typing.Optional[int] = None
    data: typing.Optional[typing.List[Company]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


CompaniesRetrieveResponse = typing_extensions.Annotated[
    typing.Union[CompaniesRetrieveResponse_Company, CompaniesRetrieveResponse_List], UnionMetadata(discriminant="type")
]
