# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .data_export_status import DataExportStatus


class DataExport(UncheckedBaseModel):
    """
    The data export api is used to view all message sent & viewed in a given timeframe.
    """

    job_identifier: typing.Optional[str] = pydantic.Field(default=None)
    """
    The identifier for your job.
    """

    status: typing.Optional[DataExportStatus] = pydantic.Field(default=None)
    """
    The current state of your job.
    """

    download_expires_at: typing.Optional[str] = pydantic.Field(default=None)
    """
    The time after which you will not be able to access the data.
    """

    download_url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The location where you can download your data.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
