# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawExportClient, RawExportClient
from .types.get_export_reporting_data_get_datasets_response import GetExportReportingDataGetDatasetsResponse
from .types.post_export_reporting_data_enqueue_response import PostExportReportingDataEnqueueResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ExportClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawExportClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawExportClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawExportClient
        """
        return self._raw_client

    def enqueue_a_new_reporting_data_export_job(
        self,
        *,
        dataset_id: str,
        attribute_ids: typing.Sequence[str],
        start_time: int,
        end_time: int,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PostExportReportingDataEnqueueResponse:
        """
        Parameters
        ----------
        dataset_id : str

        attribute_ids : typing.Sequence[str]

        start_time : int

        end_time : int

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostExportReportingDataEnqueueResponse
            Job enqueued successfully

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.export.enqueue_a_new_reporting_data_export_job(
            dataset_id="conversation",
            attribute_ids=["conversation_id", "conversation_started_at"],
            start_time=1717490000,
            end_time=1717510000,
        )
        """
        _response = self._raw_client.enqueue_a_new_reporting_data_export_job(
            dataset_id=dataset_id,
            attribute_ids=attribute_ids,
            start_time=start_time,
            end_time=end_time,
            request_options=request_options,
        )
        return _response.data

    def list_available_datasets_and_attributes(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetExportReportingDataGetDatasetsResponse:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetExportReportingDataGetDatasetsResponse
            List of datasets

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.export.list_available_datasets_and_attributes()
        """
        _response = self._raw_client.list_available_datasets_and_attributes(request_options=request_options)
        return _response.data


class AsyncExportClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawExportClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawExportClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawExportClient
        """
        return self._raw_client

    async def enqueue_a_new_reporting_data_export_job(
        self,
        *,
        dataset_id: str,
        attribute_ids: typing.Sequence[str],
        start_time: int,
        end_time: int,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PostExportReportingDataEnqueueResponse:
        """
        Parameters
        ----------
        dataset_id : str

        attribute_ids : typing.Sequence[str]

        start_time : int

        end_time : int

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PostExportReportingDataEnqueueResponse
            Job enqueued successfully

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.export.enqueue_a_new_reporting_data_export_job(
                dataset_id="conversation",
                attribute_ids=["conversation_id", "conversation_started_at"],
                start_time=1717490000,
                end_time=1717510000,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.enqueue_a_new_reporting_data_export_job(
            dataset_id=dataset_id,
            attribute_ids=attribute_ids,
            start_time=start_time,
            end_time=end_time,
            request_options=request_options,
        )
        return _response.data

    async def list_available_datasets_and_attributes(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetExportReportingDataGetDatasetsResponse:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetExportReportingDataGetDatasetsResponse
            List of datasets

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.export.list_available_datasets_and_attributes()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_available_datasets_and_attributes(request_options=request_options)
        return _response.data
