# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..help_center.types.help_center import HelpCenter
from ..help_center.types.help_center_list import HelpCenterList
from .raw_client import AsyncRawHelpCentersClient, RawHelpCentersClient

if typing.TYPE_CHECKING:
    from .collections.client import AsyncCollectionsClient, CollectionsClient


class HelpCentersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawHelpCentersClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._collections: typing.Optional[CollectionsClient] = None

    @property
    def with_raw_response(self) -> RawHelpCentersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawHelpCentersClient
        """
        return self._raw_client

    def find(self, help_center_id: int, *, request_options: typing.Optional[RequestOptions] = None) -> HelpCenter:
        """
        You can fetch the details of a single Help Center by making a GET request to `https://api.intercom.io/help_center/help_center/<id>`.

        Parameters
        ----------
        help_center_id : int
            The unique identifier for the collection which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HelpCenter
            Collection found

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.help_centers.find(
            help_center_id=1,
        )
        """
        _response = self._raw_client.find(help_center_id, request_options=request_options)
        return _response.data

    def list(
        self,
        *,
        page: typing.Optional[int] = None,
        per_page: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[HelpCenter, HelpCenterList]:
        """
        You can list all Help Centers by making a GET request to `https://api.intercom.io/help_center/help_centers`.

        Parameters
        ----------
        page : typing.Optional[int]
            The page of results to fetch. Defaults to first page

        per_page : typing.Optional[int]
            How many results to display per page. Defaults to 15

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[HelpCenter, HelpCenterList]
            Help Centers found

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        response = client.help_centers.list()
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(page=page, per_page=per_page, request_options=request_options)

    @property
    def collections(self):
        if self._collections is None:
            from .collections.client import CollectionsClient  # noqa: E402

            self._collections = CollectionsClient(client_wrapper=self._client_wrapper)
        return self._collections


class AsyncHelpCentersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawHelpCentersClient(client_wrapper=client_wrapper)
        self._client_wrapper = client_wrapper
        self._collections: typing.Optional[AsyncCollectionsClient] = None

    @property
    def with_raw_response(self) -> AsyncRawHelpCentersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawHelpCentersClient
        """
        return self._raw_client

    async def find(self, help_center_id: int, *, request_options: typing.Optional[RequestOptions] = None) -> HelpCenter:
        """
        You can fetch the details of a single Help Center by making a GET request to `https://api.intercom.io/help_center/help_center/<id>`.

        Parameters
        ----------
        help_center_id : int
            The unique identifier for the collection which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HelpCenter
            Collection found

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.help_centers.find(
                help_center_id=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.find(help_center_id, request_options=request_options)
        return _response.data

    async def list(
        self,
        *,
        page: typing.Optional[int] = None,
        per_page: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[HelpCenter, HelpCenterList]:
        """
        You can list all Help Centers by making a GET request to `https://api.intercom.io/help_center/help_centers`.

        Parameters
        ----------
        page : typing.Optional[int]
            The page of results to fetch. Defaults to first page

        per_page : typing.Optional[int]
            How many results to display per page. Defaults to 15

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[HelpCenter, HelpCenterList]
            Help Centers found

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.help_centers.list()
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(page=page, per_page=per_page, request_options=request_options)

    @property
    def collections(self):
        if self._collections is None:
            from .collections.client import AsyncCollectionsClient  # noqa: E402

            self._collections = AsyncCollectionsClient(client_wrapper=self._client_wrapper)
        return self._collections
