# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.ip_allowlist import IpAllowlist
from .raw_client import AsyncRawIpAllowlistClient, RawIpAllowlistClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class IpAllowlistClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawIpAllowlistClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawIpAllowlistClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawIpAllowlistClient
        """
        return self._raw_client

    def get_ip_allowlist(self, *, request_options: typing.Optional[RequestOptions] = None) -> IpAllowlist:
        """
        Retrieve the current IP allowlist configuration for the workspace.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IpAllowlist
            Successful response

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.ip_allowlist.get_ip_allowlist()
        """
        _response = self._raw_client.get_ip_allowlist(request_options=request_options)
        return _response.data

    def update_ip_allowlist(
        self,
        *,
        type: typing.Optional[str] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        ip_allowlist: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> IpAllowlist:
        """
        Update the IP allowlist configuration for the workspace.

        {% admonition type="warning" name="Lockout Protection" %}
          The API will reject updates that would lock out the caller's IP address. Ensure your current IP is included in the allowlist when enabling the feature.
        {% /admonition %}

        Parameters
        ----------
        type : typing.Optional[str]
            String representing the object's type. Always has the value `ip_allowlist`.

        enabled : typing.Optional[bool]
            Whether the IP allowlist is enabled for the workspace.

        ip_allowlist : typing.Optional[typing.Sequence[str]]
            List of allowed IP addresses and/or IP ranges in CIDR notation.
            Examples:
            - Single IP: `192.168.0.1`
            - IP range: `192.168.0.1/24` (allows 192.168.0.0 - 192.168.0.255)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IpAllowlist
            Successful response

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.ip_allowlist.update_ip_allowlist(
            enabled=True,
            ip_allowlist=["192.168.1.0/24", "10.0.0.1"],
        )
        """
        _response = self._raw_client.update_ip_allowlist(
            type=type, enabled=enabled, ip_allowlist=ip_allowlist, request_options=request_options
        )
        return _response.data


class AsyncIpAllowlistClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawIpAllowlistClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawIpAllowlistClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawIpAllowlistClient
        """
        return self._raw_client

    async def get_ip_allowlist(self, *, request_options: typing.Optional[RequestOptions] = None) -> IpAllowlist:
        """
        Retrieve the current IP allowlist configuration for the workspace.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IpAllowlist
            Successful response

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.ip_allowlist.get_ip_allowlist()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_ip_allowlist(request_options=request_options)
        return _response.data

    async def update_ip_allowlist(
        self,
        *,
        type: typing.Optional[str] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        ip_allowlist: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> IpAllowlist:
        """
        Update the IP allowlist configuration for the workspace.

        {% admonition type="warning" name="Lockout Protection" %}
          The API will reject updates that would lock out the caller's IP address. Ensure your current IP is included in the allowlist when enabling the feature.
        {% /admonition %}

        Parameters
        ----------
        type : typing.Optional[str]
            String representing the object's type. Always has the value `ip_allowlist`.

        enabled : typing.Optional[bool]
            Whether the IP allowlist is enabled for the workspace.

        ip_allowlist : typing.Optional[typing.Sequence[str]]
            List of allowed IP addresses and/or IP ranges in CIDR notation.
            Examples:
            - Single IP: `192.168.0.1`
            - IP range: `192.168.0.1/24` (allows 192.168.0.0 - 192.168.0.255)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        IpAllowlist
            Successful response

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.ip_allowlist.update_ip_allowlist(
                enabled=True,
                ip_allowlist=["192.168.1.0/24", "10.0.0.1"],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_ip_allowlist(
            type=type, enabled=enabled, ip_allowlist=ip_allowlist, request_options=request_options
        )
        return _response.data
