# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.request_options import RequestOptions
from ..core.unchecked_base_model import construct_type
from ..errors.unauthorized_error import UnauthorizedError
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.error import Error
from ..types.ip_allowlist import IpAllowlist

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawIpAllowlistClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_ip_allowlist(self, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[IpAllowlist]:
        """
        Retrieve the current IP allowlist configuration for the workspace.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[IpAllowlist]
            Successful response
        """
        _response = self._client_wrapper.httpx_client.request(
            "ip_allowlist",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    IpAllowlist,
                    construct_type(
                        type_=IpAllowlist,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_ip_allowlist(
        self,
        *,
        type: typing.Optional[str] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        ip_allowlist: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[IpAllowlist]:
        """
        Update the IP allowlist configuration for the workspace.

        {% admonition type="warning" name="Lockout Protection" %}
          The API will reject updates that would lock out the caller's IP address. Ensure your current IP is included in the allowlist when enabling the feature.
        {% /admonition %}

        Parameters
        ----------
        type : typing.Optional[str]
            String representing the object's type. Always has the value `ip_allowlist`.

        enabled : typing.Optional[bool]
            Whether the IP allowlist is enabled for the workspace.

        ip_allowlist : typing.Optional[typing.Sequence[str]]
            List of allowed IP addresses and/or IP ranges in CIDR notation.
            Examples:
            - Single IP: `192.168.0.1`
            - IP range: `192.168.0.1/24` (allows 192.168.0.0 - 192.168.0.255)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[IpAllowlist]
            Successful response
        """
        _response = self._client_wrapper.httpx_client.request(
            "ip_allowlist",
            method="PUT",
            json={
                "type": type,
                "enabled": enabled,
                "ip_allowlist": ip_allowlist,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    IpAllowlist,
                    construct_type(
                        type_=IpAllowlist,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawIpAllowlistClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_ip_allowlist(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[IpAllowlist]:
        """
        Retrieve the current IP allowlist configuration for the workspace.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[IpAllowlist]
            Successful response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "ip_allowlist",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    IpAllowlist,
                    construct_type(
                        type_=IpAllowlist,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_ip_allowlist(
        self,
        *,
        type: typing.Optional[str] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        ip_allowlist: typing.Optional[typing.Sequence[str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[IpAllowlist]:
        """
        Update the IP allowlist configuration for the workspace.

        {% admonition type="warning" name="Lockout Protection" %}
          The API will reject updates that would lock out the caller's IP address. Ensure your current IP is included in the allowlist when enabling the feature.
        {% /admonition %}

        Parameters
        ----------
        type : typing.Optional[str]
            String representing the object's type. Always has the value `ip_allowlist`.

        enabled : typing.Optional[bool]
            Whether the IP allowlist is enabled for the workspace.

        ip_allowlist : typing.Optional[typing.Sequence[str]]
            List of allowed IP addresses and/or IP ranges in CIDR notation.
            Examples:
            - Single IP: `192.168.0.1`
            - IP range: `192.168.0.1/24` (allows 192.168.0.0 - 192.168.0.255)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[IpAllowlist]
            Successful response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "ip_allowlist",
            method="PUT",
            json={
                "type": type,
                "enabled": enabled,
                "ip_allowlist": ip_allowlist,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    IpAllowlist,
                    construct_type(
                        type_=IpAllowlist,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
