# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.create_message_request import CreateMessageRequest
from .raw_client import AsyncRawMessagesClient, RawMessagesClient
from .types.message import Message

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class MessagesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawMessagesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawMessagesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawMessagesClient
        """
        return self._raw_client

    def create(
        self,
        *,
        request: typing.Optional[CreateMessageRequest] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Message:
        """
        You can create a message that has been initiated by an admin. The conversation can be either an in-app message or an email.

        > 🚧 Sending for visitors
        >
        > There can be a short delay between when a contact is created and when a contact becomes available to be messaged through the API. A 404 Not Found error will be returned in this case.

        This will return the Message model that has been created.

        > 🚧 Retrieving Associated Conversations
        >
        > As this is a message, there will be no conversation present until the contact responds. Once they do, you will have to search for a contact's conversations with the id of the message.

        Parameters
        ----------
        request : typing.Optional[CreateMessageRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Message
            admin message created

        Examples
        --------
        from intercom import (
            CreateMessageRequest_Email,
            CreateMessageRequestFrom,
            CreateMessageRequestTo,
            Intercom,
        )

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.messages.create(
            request=CreateMessageRequest_Email(
                subject="Thanks for everything",
                body="Hello there",
                template="plain",
                from_=CreateMessageRequestFrom(
                    id=394051,
                ),
                to=CreateMessageRequestTo(
                    type="user",
                    id="536e564f316c83104c000020",
                ),
            ),
        )
        """
        _response = self._raw_client.create(request=request, request_options=request_options)
        return _response.data


class AsyncMessagesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawMessagesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawMessagesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawMessagesClient
        """
        return self._raw_client

    async def create(
        self,
        *,
        request: typing.Optional[CreateMessageRequest] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Message:
        """
        You can create a message that has been initiated by an admin. The conversation can be either an in-app message or an email.

        > 🚧 Sending for visitors
        >
        > There can be a short delay between when a contact is created and when a contact becomes available to be messaged through the API. A 404 Not Found error will be returned in this case.

        This will return the Message model that has been created.

        > 🚧 Retrieving Associated Conversations
        >
        > As this is a message, there will be no conversation present until the contact responds. Once they do, you will have to search for a contact's conversations with the id of the message.

        Parameters
        ----------
        request : typing.Optional[CreateMessageRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Message
            admin message created

        Examples
        --------
        import asyncio

        from intercom import (
            AsyncIntercom,
            CreateMessageRequest_Email,
            CreateMessageRequestFrom,
            CreateMessageRequestTo,
        )

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.messages.create(
                request=CreateMessageRequest_Email(
                    subject="Thanks for everything",
                    body="Hello there",
                    template="plain",
                    from_=CreateMessageRequestFrom(
                        id=394051,
                    ),
                    to=CreateMessageRequestTo(
                        type="user",
                        id="536e564f316c83104c000020",
                    ),
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(request=request, request_options=request_options)
        return _response.data
