# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.paginated_response import PaginatedResponse
from ..types.newsfeed import Newsfeed
from .raw_client import AsyncRawFeedsClient, RawFeedsClient


class FeedsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawFeedsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawFeedsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawFeedsClient
        """
        return self._raw_client

    def list_items(
        self, newsfeed_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PaginatedResponse:
        """
        You can fetch a list of all news items that are live on a given newsfeed

        Parameters
        ----------
        newsfeed_id : str
            The unique identifier for the news feed item which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedResponse
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.news.feeds.list_items(
            newsfeed_id="123",
        )
        """
        _response = self._raw_client.list_items(newsfeed_id, request_options=request_options)
        return _response.data

    def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> PaginatedResponse:
        """
        You can fetch a list of all newsfeeds

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedResponse
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.news.feeds.list()
        """
        _response = self._raw_client.list(request_options=request_options)
        return _response.data

    def find(self, newsfeed_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Newsfeed:
        """
        You can fetch the details of a single newsfeed

        Parameters
        ----------
        newsfeed_id : str
            The unique identifier for the news feed item which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Newsfeed
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.news.feeds.find(
            newsfeed_id="123",
        )
        """
        _response = self._raw_client.find(newsfeed_id, request_options=request_options)
        return _response.data


class AsyncFeedsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawFeedsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawFeedsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawFeedsClient
        """
        return self._raw_client

    async def list_items(
        self, newsfeed_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PaginatedResponse:
        """
        You can fetch a list of all news items that are live on a given newsfeed

        Parameters
        ----------
        newsfeed_id : str
            The unique identifier for the news feed item which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedResponse
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.news.feeds.list_items(
                newsfeed_id="123",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_items(newsfeed_id, request_options=request_options)
        return _response.data

    async def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> PaginatedResponse:
        """
        You can fetch a list of all newsfeeds

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedResponse
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.news.feeds.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(request_options=request_options)
        return _response.data

    async def find(self, newsfeed_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Newsfeed:
        """
        You can fetch the details of a single newsfeed

        Parameters
        ----------
        newsfeed_id : str
            The unique identifier for the news feed item which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Newsfeed
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.news.feeds.find(
                newsfeed_id="123",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.find(newsfeed_id, request_options=request_options)
        return _response.data
