# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.create_phone_switch_request import CreatePhoneSwitchRequest
from ..types.phone_switch import PhoneSwitch
from .raw_client import AsyncRawPhoneCallRedirectsClient, RawPhoneCallRedirectsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class PhoneCallRedirectsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPhoneCallRedirectsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPhoneCallRedirectsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPhoneCallRedirectsClient
        """
        return self._raw_client

    def create(
        self,
        *,
        request: typing.Optional[CreatePhoneSwitchRequest] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[PhoneSwitch]:
        """
        You can use the API to deflect phone calls to the Intercom Messenger.
        Calling this endpoint will send an SMS with a link to the Messenger to the phone number specified.

        If custom attributes are specified, they will be added to the user or lead's custom data attributes.

        Parameters
        ----------
        request : typing.Optional[CreatePhoneSwitchRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[PhoneSwitch]
            successful

        Examples
        --------
        from intercom import CreatePhoneSwitchRequest, Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.phone_call_redirects.create(
            request=CreatePhoneSwitchRequest(
                phone="+353832345678",
                custom_attributes={"issue_type": "Billing", "priority": "High"},
            ),
        )
        """
        _response = self._raw_client.create(request=request, request_options=request_options)
        return _response.data


class AsyncPhoneCallRedirectsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPhoneCallRedirectsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPhoneCallRedirectsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPhoneCallRedirectsClient
        """
        return self._raw_client

    async def create(
        self,
        *,
        request: typing.Optional[CreatePhoneSwitchRequest] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[PhoneSwitch]:
        """
        You can use the API to deflect phone calls to the Intercom Messenger.
        Calling this endpoint will send an SMS with a link to the Messenger to the phone number specified.

        If custom attributes are specified, they will be added to the user or lead's custom data attributes.

        Parameters
        ----------
        request : typing.Optional[CreatePhoneSwitchRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[PhoneSwitch]
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom, CreatePhoneSwitchRequest

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.phone_call_redirects.create(
                request=CreatePhoneSwitchRequest(
                    phone="+353832345678",
                    custom_attributes={"issue_type": "Billing", "priority": "High"},
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(request=request, request_options=request_options)
        return _response.data
