# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from ...types.admin_priority_level import AdminPriorityLevel


class Team(UncheckedBaseModel):
    """
    Teams are groups of admins in Intercom.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    Value is always "team"
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the team
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the team
    """

    admin_ids: typing.Optional[typing.List[int]] = pydantic.Field(default=None)
    """
    The list of admin IDs that are a part of the team.
    """

    admin_priority_level: typing.Optional[AdminPriorityLevel] = None
    assignment_limit: typing.Optional[int] = pydantic.Field(default=None)
    """
    The assignment limit for the team. This field is only present when the team's distribution type is load balanced.
    """

    distribution_method: typing.Optional[str] = pydantic.Field(default=None)
    """
    Describes how assignments are distributed among the team members
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
