# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..core.unchecked_base_model import construct_type
from ..errors.unauthorized_error import UnauthorizedError
from ..tickets.types.ticket_type import TicketType
from ..types.create_ticket_type_request import CreateTicketTypeRequest
from ..types.error import Error
from ..types.ticket_type_list import TicketTypeList
from .types.update_ticket_type_request_category import UpdateTicketTypeRequestCategory

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawTicketTypesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(self, *, request_options: typing.Optional[RequestOptions] = None) -> HttpResponse[TicketTypeList]:
        """
        You can get a list of all ticket types for a workspace.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[TicketTypeList]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            "ticket_types",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TicketTypeList,
                    construct_type(
                        type_=TicketTypeList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        *,
        request: typing.Optional[CreateTicketTypeRequest] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.Optional[TicketType]]:
        """
        You can create a new ticket type.
        > 📘 Creating ticket types.
        >
        > Every ticket type will be created with two default attributes: _default_title_ and _default_description_.
        > For the `icon` propery, use an emoji from [Twemoji Cheatsheet](https://twemoji-cheatsheet.vercel.app/)

        Parameters
        ----------
        request : typing.Optional[CreateTicketTypeRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Optional[TicketType]]
            Ticket type created
        """
        _response = self._client_wrapper.httpx_client.request(
            "ticket_types",
            method="POST",
            json=convert_and_respect_annotation_metadata(
                object_=request, annotation=CreateTicketTypeRequest, direction="write"
            ),
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if _response is None or not _response.text.strip():
                return HttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[TicketType],
                    construct_type(
                        type_=typing.Optional[TicketType],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self, ticket_type_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.Optional[TicketType]]:
        """
        You can fetch the details of a single ticket type.

        Parameters
        ----------
        ticket_type_id : str
            The unique identifier for the ticket type which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Optional[TicketType]]
            Ticket type found
        """
        _response = self._client_wrapper.httpx_client.request(
            f"ticket_types/{jsonable_encoder(ticket_type_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if _response is None or not _response.text.strip():
                return HttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[TicketType],
                    construct_type(
                        type_=typing.Optional[TicketType],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        ticket_type_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        category: typing.Optional[UpdateTicketTypeRequestCategory] = OMIT,
        icon: typing.Optional[str] = OMIT,
        archived: typing.Optional[bool] = OMIT,
        is_internal: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.Optional[TicketType]]:
        """

        You can update a ticket type.

        > 📘 Updating a ticket type.
        >
        > For the `icon` propery, use an emoji from [Twemoji Cheatsheet](https://twemoji-cheatsheet.vercel.app/)

        Parameters
        ----------
        ticket_type_id : str
            The unique identifier for the ticket type which is given by Intercom.

        name : typing.Optional[str]
            The name of the ticket type.

        description : typing.Optional[str]
            The description of the ticket type.

        category : typing.Optional[UpdateTicketTypeRequestCategory]
            Category of the Ticket Type.

        icon : typing.Optional[str]
            The icon of the ticket type.

        archived : typing.Optional[bool]
            The archived status of the ticket type.

        is_internal : typing.Optional[bool]
            Whether the tickets associated with this ticket type are intended for internal use only or will be shared with customers. This is currently a limited attribute.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Optional[TicketType]]
            Ticket type updated
        """
        _response = self._client_wrapper.httpx_client.request(
            f"ticket_types/{jsonable_encoder(ticket_type_id)}",
            method="PUT",
            json={
                "name": name,
                "description": description,
                "category": category,
                "icon": icon,
                "archived": archived,
                "is_internal": is_internal,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if _response is None or not _response.text.strip():
                return HttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[TicketType],
                    construct_type(
                        type_=typing.Optional[TicketType],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawTicketTypesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[TicketTypeList]:
        """
        You can get a list of all ticket types for a workspace.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[TicketTypeList]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            "ticket_types",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    TicketTypeList,
                    construct_type(
                        type_=TicketTypeList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        *,
        request: typing.Optional[CreateTicketTypeRequest] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.Optional[TicketType]]:
        """
        You can create a new ticket type.
        > 📘 Creating ticket types.
        >
        > Every ticket type will be created with two default attributes: _default_title_ and _default_description_.
        > For the `icon` propery, use an emoji from [Twemoji Cheatsheet](https://twemoji-cheatsheet.vercel.app/)

        Parameters
        ----------
        request : typing.Optional[CreateTicketTypeRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Optional[TicketType]]
            Ticket type created
        """
        _response = await self._client_wrapper.httpx_client.request(
            "ticket_types",
            method="POST",
            json=convert_and_respect_annotation_metadata(
                object_=request, annotation=CreateTicketTypeRequest, direction="write"
            ),
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if _response is None or not _response.text.strip():
                return AsyncHttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[TicketType],
                    construct_type(
                        type_=typing.Optional[TicketType],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self, ticket_type_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.Optional[TicketType]]:
        """
        You can fetch the details of a single ticket type.

        Parameters
        ----------
        ticket_type_id : str
            The unique identifier for the ticket type which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Optional[TicketType]]
            Ticket type found
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"ticket_types/{jsonable_encoder(ticket_type_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if _response is None or not _response.text.strip():
                return AsyncHttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[TicketType],
                    construct_type(
                        type_=typing.Optional[TicketType],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        ticket_type_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        category: typing.Optional[UpdateTicketTypeRequestCategory] = OMIT,
        icon: typing.Optional[str] = OMIT,
        archived: typing.Optional[bool] = OMIT,
        is_internal: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.Optional[TicketType]]:
        """

        You can update a ticket type.

        > 📘 Updating a ticket type.
        >
        > For the `icon` propery, use an emoji from [Twemoji Cheatsheet](https://twemoji-cheatsheet.vercel.app/)

        Parameters
        ----------
        ticket_type_id : str
            The unique identifier for the ticket type which is given by Intercom.

        name : typing.Optional[str]
            The name of the ticket type.

        description : typing.Optional[str]
            The description of the ticket type.

        category : typing.Optional[UpdateTicketTypeRequestCategory]
            Category of the Ticket Type.

        icon : typing.Optional[str]
            The icon of the ticket type.

        archived : typing.Optional[bool]
            The archived status of the ticket type.

        is_internal : typing.Optional[bool]
            Whether the tickets associated with this ticket type are intended for internal use only or will be shared with customers. This is currently a limited attribute.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Optional[TicketType]]
            Ticket type updated
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"ticket_types/{jsonable_encoder(ticket_type_id)}",
            method="PUT",
            json={
                "name": name,
                "description": description,
                "category": category,
                "icon": icon,
                "archived": archived,
                "is_internal": is_internal,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if _response is None or not _response.text.strip():
                return AsyncHttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[TicketType],
                    construct_type(
                        type_=typing.Optional[TicketType],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
