# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class CompanyData(UncheckedBaseModel):
    """
    An object containing data about the companies that a contact is associated with.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier for the company which is given by Intercom.
    """

    type: typing.Optional[typing.Literal["company"]] = pydantic.Field(default=None)
    """
    The type of the object. Always company.
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The relative URL of the company.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
