# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..conversations.types.conversation import Conversation
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .cursor_pages import CursorPages


class ConversationList(UncheckedBaseModel):
    """
    Conversations are how you can communicate with users in Intercom. They are created when a contact replies to an outbound message, or when one admin directly sends a message to a single contact.
    """

    type: typing.Optional[typing.Literal["conversation.list"]] = pydantic.Field(default=None)
    """
    Always conversation.list
    """

    conversations: typing.Optional[typing.List[Conversation]] = pydantic.Field(default=None)
    """
    The list of conversation objects
    """

    total_count: typing.Optional[int] = pydantic.Field(default=None)
    """
    A count of the total number of objects.
    """

    pages: typing.Optional[CursorPages] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
