# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from ..tags.types.tag_basic import TagBasic
from .conversation_part_author import ConversationPartAuthor
from .conversation_part_metadata import ConversationPartMetadata
from .conversation_part_state import ConversationPartState
from .email_message_metadata import EmailMessageMetadata
from .event_details import EventDetails
from .part_attachment import PartAttachment
from .reference import Reference


class ConversationPart(UncheckedBaseModel):
    """
    A Conversation Part represents a message in the conversation.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    Always conversation_part
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id representing the conversation part.
    """

    part_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of conversation part.
    """

    body: typing.Optional[str] = pydantic.Field(default=None)
    """
    The message body, which may contain HTML. For Twitter, this will show a generic message regarding why the body is obscured.
    """

    created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time the conversation part was created.
    """

    updated_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The last time the conversation part was updated.
    """

    notified_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time the user was notified with the conversation part.
    """

    assigned_to: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The id of the admin that was assigned the conversation by this conversation_part (null if there has been no change in assignment.)
    """

    author: typing.Optional[ConversationPartAuthor] = None
    attachments: typing.Optional[typing.List[PartAttachment]] = pydantic.Field(default=None)
    """
    A list of attachments for the part.
    """

    external_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The external id of the conversation part
    """

    redacted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether or not the conversation part has been redacted.
    """

    email_message_metadata: typing.Optional[EmailMessageMetadata] = None
    metadata: typing.Optional[ConversationPartMetadata] = None
    state: typing.Optional[ConversationPartState] = pydantic.Field(default=None)
    """
    Indicates the current state of conversation when the conversation part was created.
    """

    tags: typing.Optional[typing.List[TagBasic]] = pydantic.Field(default=None)
    """
    A list of tags objects associated with the conversation part.
    """

    event_details: typing.Optional[EventDetails] = None
    app_package_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    The app package code if this part was created via API. null if the part was not created via API.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
