# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class CreateContactRequestWithExternalId(UncheckedBaseModel):
    external_id: str = pydantic.Field()
    """
    A unique identifier for the contact which is given to Intercom
    """

    phone: typing.Optional[str] = pydantic.Field(default=None)
    """
    The contacts phone
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The contacts name
    """

    avatar: typing.Optional[str] = pydantic.Field(default=None)
    """
    An image URL containing the avatar of a contact
    """

    signed_up_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time specified for when a contact signed up
    """

    last_seen_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time when the contact was last seen (either where the Intercom Messenger was installed or when specified manually)
    """

    owner_id: typing.Optional[int] = pydantic.Field(default=None)
    """
    The id of an admin that has been assigned account ownership of the contact
    """

    unsubscribed_from_emails: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the contact is unsubscribed from emails
    """

    custom_attributes: typing.Optional[typing.Dict[str, typing.Any]] = pydantic.Field(default=None)
    """
    The custom attributes which are set for the contact
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
