# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel, UnionMetadata
from .create_message_request_from import CreateMessageRequestFrom
from .create_message_request_to import CreateMessageRequestTo


class CreateMessageRequest_Email(UncheckedBaseModel):
    """
    You can create a message
    """

    message_type: typing.Literal["email"] = "email"
    subject: str
    body: str
    template: str
    from_: typing_extensions.Annotated[CreateMessageRequestFrom, FieldMetadata(alias="from")]
    to: CreateMessageRequestTo
    created_at: typing.Optional[int] = None
    create_conversation_without_contact_reply: typing.Optional[bool] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class CreateMessageRequest_Inapp(UncheckedBaseModel):
    """
    You can create a message
    """

    message_type: typing.Literal["inapp"] = "inapp"
    subject: typing.Optional[str] = None
    body: str
    template: typing.Optional[str] = None
    from_: typing_extensions.Annotated[CreateMessageRequestFrom, FieldMetadata(alias="from")]
    to: CreateMessageRequestTo
    created_at: typing.Optional[int] = None
    create_conversation_without_contact_reply: typing.Optional[bool] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


CreateMessageRequest = typing_extensions.Annotated[
    typing.Union[CreateMessageRequest_Email, CreateMessageRequest_Inapp], UnionMetadata(discriminant="message_type")
]
