# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class IpAllowlist(UncheckedBaseModel):
    """
    IP allowlist settings for the workspace.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    String representing the object's type. Always has the value `ip_allowlist`.
    """

    enabled: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the IP allowlist is enabled for the workspace.
    """

    ip_allowlist: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of allowed IP addresses and/or IP ranges in CIDR notation.
    Examples:
    - Single IP: `192.168.0.1`
    - IP range: `192.168.0.1/24` (allows 192.168.0.0 - 192.168.0.255)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
